/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JTATransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.JTAHelper;
import org.hibernate.util.NamingHelper;

public class JTATransactionFactory
implements TransactionFactory {
    private static final Log log = LogFactory.getLog((Class)JTATransactionFactory.class);
    private static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    protected InitialContext context;
    protected String utName;

    public void configure(Properties properties) throws HibernateException {
        TransactionManagerLookup transactionManagerLookup;
        try {
            this.context = NamingHelper.getInitialContext(properties);
        }
        catch (NamingException namingException) {
            log.error((Object)"Could not obtain initial context", (Throwable)namingException);
            throw new HibernateException("Could not obtain initial context", namingException);
        }
        this.utName = properties.getProperty("jta.UserTransaction");
        if (this.utName == null && (transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup(properties)) != null) {
            this.utName = transactionManagerLookup.getUserTransactionName();
        }
        if (this.utName == null) {
            this.utName = DEFAULT_USER_TRANSACTION_NAME;
        }
    }

    public Transaction createTransaction(JDBCContext jDBCContext, TransactionFactory.Context context) throws HibernateException {
        return new JTATransaction(this.context, this.utName, jDBCContext, context);
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    public boolean isTransactionManagerRequired() {
        return false;
    }

    public boolean areCallbacksLocalToHibernateTransactions() {
        return false;
    }

    public boolean isTransactionInProgress(JDBCContext jDBCContext, TransactionFactory.Context context, Transaction transaction) {
        try {
            UserTransaction userTransaction;
            if (transaction != null && (userTransaction = ((JTATransaction)transaction).getUserTransaction()) != null) {
                return JTAHelper.isInProgress(userTransaction.getStatus());
            }
            if (jDBCContext.getFactory().getTransactionManager() != null) {
                return JTAHelper.isInProgress(jDBCContext.getFactory().getTransactionManager().getStatus());
            }
            try {
                userTransaction = (UserTransaction)this.context.lookup(this.utName);
                return userTransaction != null && JTAHelper.isInProgress(userTransaction.getStatus());
            }
            catch (NamingException namingException) {
                throw new TransactionException("Unable to locate UserTransaction to check status", namingException);
            }
        }
        catch (SystemException systemException) {
            throw new TransactionException("Unable to check transaction status", (Exception)((Object)systemException));
        }
    }
}

