/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JTATransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)JTATransaction.class);
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private UserTransaction ut;
    private boolean newTransaction;
    private boolean begun;
    private boolean commitFailed;
    private boolean commitSucceeded;
    private boolean callback;
    private static final int NULL = Integer.MIN_VALUE;

    public JTATransaction(InitialContext initialContext, String string, JDBCContext jDBCContext, TransactionFactory.Context context) {
        this.jdbcContext = jDBCContext;
        this.transactionContext = context;
        log.debug((Object)("Looking for UserTransaction under: " + string));
        try {
            this.ut = (UserTransaction)initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            log.error((Object)"Could not find UserTransaction in JNDI", (Throwable)namingException);
            throw new TransactionException("Could not find UserTransaction in JNDI: ", namingException);
        }
        if (this.ut == null) {
            throw new AssertionFailure("A naming service lookup returned null");
        }
        log.debug((Object)"Obtained UserTransaction");
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        if (this.commitFailed) {
            throw new TransactionException("cannot re-start transaction after failed commit");
        }
        log.debug((Object)"begin");
        try {
            boolean bl = this.newTransaction = this.ut.getStatus() == 6;
            if (this.newTransaction) {
                this.ut.begin();
                log.debug((Object)"Began a new JTA transaction");
            }
        }
        catch (Exception exception) {
            log.error((Object)"JTA transaction begin failed", (Throwable)exception);
            throw new TransactionException("JTA transaction begin failed", exception);
        }
        boolean bl = this.jdbcContext.registerSynchronizationIfPossible();
        if (!this.newTransaction && !bl) {
            log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
        }
        if (!bl) {
            this.callback = this.jdbcContext.registerCallbackIfNecessary();
        }
        this.begun = true;
        this.commitSucceeded = false;
        this.jdbcContext.afterTransactionBegin(this);
    }

    public void commit() throws HibernateException {
        boolean bl;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        boolean bl2 = bl = !this.transactionContext.isFlushModeNever() && (this.callback || !this.transactionContext.isFlushBeforeCompletionEnabled());
        if (bl) {
            this.transactionContext.managedFlush();
        }
        if (this.callback && this.newTransaction) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        this.closeIfRequired();
        if (this.newTransaction) {
            try {
                this.ut.commit();
                this.commitSucceeded = true;
                log.debug((Object)"Committed JTA UserTransaction");
            }
            catch (Exception exception) {
                this.commitFailed = true;
                log.error((Object)"JTA commit failed", (Throwable)exception);
                throw new TransactionException("JTA commit failed: ", exception);
            }
            finally {
                this.afterCommitRollback();
            }
        } else {
            this.afterCommitRollback();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun && !this.commitFailed) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        try {
            this.closeIfRequired();
        }
        catch (Exception exception) {
            log.error((Object)"could not close session during rollback", (Throwable)exception);
        }
        try {
            if (this.newTransaction) {
                if (!this.commitFailed) {
                    this.ut.rollback();
                    log.debug((Object)"Rolled back JTA UserTransaction");
                }
            } else {
                this.ut.setRollbackOnly();
                log.debug((Object)"set JTA UserTransaction to rollback only");
            }
        }
        catch (Exception exception) {
            log.error((Object)"JTA rollback failed", (Throwable)exception);
            throw new TransactionException("JTA rollback failed", exception);
        }
        finally {
            this.afterCommitRollback();
        }
    }

    private void afterCommitRollback() throws TransactionException {
        this.begun = false;
        if (this.callback) {
            if (!this.newTransaction) {
                log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
            }
            int n = Integer.MIN_VALUE;
            try {
                n = this.ut.getStatus();
                this.jdbcContext.afterTransactionCompletion(n == 3, this);
            }
            catch (Exception exception) {
                try {
                    log.error((Object)"Could not determine transaction status after commit", (Throwable)exception);
                    throw new TransactionException("Could not determine transaction status after commit", exception);
                }
                catch (Throwable throwable) {
                    this.jdbcContext.afterTransactionCompletion(n == 3, this);
                    throw throwable;
                }
            }
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        int n;
        try {
            n = this.ut.getStatus();
        }
        catch (SystemException systemException) {
            log.error((Object)"Could not determine transaction status", (Throwable)systemException);
            throw new TransactionException("Could not determine transaction status", (Exception)((Object)systemException));
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(n);
    }

    public boolean wasCommitted() throws TransactionException {
        int n;
        try {
            n = this.ut.getStatus();
        }
        catch (SystemException systemException) {
            log.error((Object)"Could not determine transaction status", (Throwable)systemException);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)systemException));
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 3;
    }

    public boolean isActive() throws TransactionException {
        int n;
        if (!this.begun || this.commitFailed || this.commitSucceeded) {
            return false;
        }
        try {
            n = this.ut.getStatus();
        }
        catch (SystemException systemException) {
            log.error((Object)"Could not determine transaction status", (Throwable)systemException);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)systemException));
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 0;
    }

    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        if (this.getTransactionManager() == null) {
            throw new IllegalStateException("JTA TransactionManager not available");
        }
        try {
            this.getTransactionManager().getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception exception) {
            throw new TransactionException("could not register synchronization", exception);
        }
    }

    private TransactionManager getTransactionManager() {
        return this.transactionContext.getFactory().getTransactionManager();
    }

    private void closeIfRequired() throws HibernateException {
        boolean bl;
        boolean bl2 = bl = this.callback && this.transactionContext.shouldAutoClose() && !this.transactionContext.isClosed();
        if (bl) {
            this.transactionContext.managedClose();
        }
    }

    public void setTimeout(int n) {
        try {
            this.ut.setTransactionTimeout(n);
        }
        catch (SystemException systemException) {
            throw new TransactionException("could not set transaction timeout", (Exception)((Object)systemException));
        }
    }

    protected UserTransaction getUserTransaction() {
        return this.ut;
    }
}

