/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public final class CacheSynchronization
implements Synchronization {
    private static final Log log = LogFactory.getLog((Class)CacheSynchronization.class);
    private final TransactionFactory.Context ctx;
    private JDBCContext jdbcContext;
    private final javax.transaction.Transaction transaction;
    private final Transaction hibernateTransaction;

    public CacheSynchronization(TransactionFactory.Context context, JDBCContext jDBCContext, javax.transaction.Transaction transaction, Transaction transaction2) {
        this.ctx = context;
        this.jdbcContext = jDBCContext;
        this.transaction = transaction;
        this.hibernateTransaction = transaction2;
    }

    public void beforeCompletion() {
        boolean bl;
        log.trace((Object)"transaction before completion callback");
        try {
            bl = !this.ctx.isFlushModeNever() && this.ctx.isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(this.transaction.getStatus());
        }
        catch (SystemException systemException) {
            log.error((Object)"could not determine transaction status", (Throwable)systemException);
            this.setRollbackOnly();
            throw new TransactionException("could not determine transaction status in beforeCompletion()", (Exception)((Object)systemException));
        }
        try {
            if (bl) {
                log.trace((Object)"automatically flushing session");
                this.ctx.managedFlush();
            }
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
        finally {
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
        }
    }

    private void setRollbackOnly() {
        try {
            this.transaction.setRollbackOnly();
        }
        catch (SystemException systemException) {
            log.error((Object)"could not set transaction to rollback only", (Throwable)systemException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterCompletion(int n) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("transaction after completion callback, status: " + n));
        }
        try {
            this.jdbcContext.afterTransactionCompletion(n == 3, this.hibernateTransaction);
            Object var3_2 = null;
            if (!this.ctx.shouldAutoClose()) return;
            if (this.ctx.isClosed()) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!this.ctx.shouldAutoClose() || this.ctx.isClosed()) throw throwable;
            log.trace((Object)"automatically closing session");
            this.ctx.managedClose();
            throw throwable;
        }
        log.trace((Object)"automatically closing session");
        this.ctx.managedClose();
    }

    public String toString() {
        return CacheSynchronization.class.getName();
    }
}

