/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.SystemException;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.CMTTransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class CMTTransactionFactory
implements TransactionFactory {
    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    public void configure(Properties properties) throws HibernateException {
    }

    public Transaction createTransaction(JDBCContext jDBCContext, TransactionFactory.Context context) throws HibernateException {
        return new CMTTransaction(jDBCContext, context);
    }

    public boolean isTransactionManagerRequired() {
        return true;
    }

    public boolean areCallbacksLocalToHibernateTransactions() {
        return false;
    }

    public boolean isTransactionInProgress(JDBCContext jDBCContext, TransactionFactory.Context context, Transaction transaction) {
        try {
            return JTAHelper.isTransactionInProgress(context.getFactory().getTransactionManager().getTransaction());
        }
        catch (SystemException systemException) {
            throw new TransactionException("Unable to check transaction status", (Exception)((Object)systemException));
        }
    }
}

