/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class CMTTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)CMTTransaction.class);
    protected final JDBCContext jdbcContext;
    protected final TransactionFactory.Context transactionContext;
    private boolean begun;

    public CMTTransaction(JDBCContext jDBCContext, TransactionFactory.Context context) {
        this.jdbcContext = jDBCContext;
        this.transactionContext = context;
    }

    public void begin() throws HibernateException {
        if (this.begun) {
            return;
        }
        log.debug((Object)"begin");
        boolean bl = this.jdbcContext.registerSynchronizationIfPossible();
        if (!bl) {
            throw new TransactionException("Could not register synchronization for container transaction");
        }
        this.begun = true;
        this.jdbcContext.afterTransactionBegin(this);
    }

    public void commit() throws HibernateException {
        boolean bl;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        boolean bl2 = bl = !this.transactionContext.isFlushModeNever() && !this.transactionContext.isFlushBeforeCompletionEnabled();
        if (bl) {
            this.transactionContext.managedFlush();
        }
        this.begun = false;
    }

    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        try {
            this.getTransaction().setRollbackOnly();
        }
        catch (SystemException systemException) {
            log.error((Object)"Could not set transaction to rollback only", (Throwable)systemException);
            throw new TransactionException("Could not set transaction to rollback only", (Exception)((Object)systemException));
        }
        this.begun = false;
    }

    public javax.transaction.Transaction getTransaction() throws SystemException {
        return this.transactionContext.getFactory().getTransactionManager().getTransaction();
    }

    public boolean isActive() throws TransactionException {
        int n;
        if (!this.begun) {
            return false;
        }
        try {
            n = this.getTransaction().getStatus();
        }
        catch (SystemException systemException) {
            log.error((Object)"Could not determine transaction status", (Throwable)systemException);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)systemException));
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 0;
    }

    public boolean wasRolledBack() throws TransactionException {
        int n;
        if (!this.begun) {
            return false;
        }
        try {
            n = this.getTransaction().getStatus();
        }
        catch (SystemException systemException) {
            log.error((Object)"Could not determine transaction status", (Throwable)systemException);
            throw new TransactionException("Could not determine transaction status", (Exception)((Object)systemException));
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(n);
    }

    public boolean wasCommitted() throws TransactionException {
        int n;
        if (!this.begun) {
            return false;
        }
        try {
            n = this.getTransaction().getStatus();
        }
        catch (SystemException systemException) {
            log.error((Object)"Could not determine transaction status", (Throwable)systemException);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)systemException));
        }
        if (n == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return n == 3;
    }

    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        try {
            this.getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception exception) {
            throw new TransactionException("Could not register synchronization", exception);
        }
    }

    public void setTimeout(int n) {
        throw new UnsupportedOperationException("cannot set transaction timeout in CMT");
    }
}

