/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument.cglib;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.sf.cglib.core.ClassNameReader;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.bytecode.util.BasicClassFilter;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.hibernate.tool.instrument.BasicInstrumentationTask;
import org.objectweb.asm.ClassReader;

public class InstrumentTask
extends BasicInstrumentationTask {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();
    static /* synthetic */ Class class$net$sf$cglib$transform$impl$InterceptFieldEnabled;

    protected ClassDescriptor getClassDescriptor(byte[] byArray) throws Exception {
        return new CustomClassDescriptor(byArray);
    }

    protected ClassTransformer getClassTransformer(ClassDescriptor classDescriptor) {
        if (classDescriptor.isInstrumented()) {
            this.logger.verbose("class [" + classDescriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new BasicInstrumentationTask.CustomFieldFilter(classDescriptor));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytecode;
        private final String name;
        private final boolean isInstrumented;

        public CustomClassDescriptor(byte[] byArray) throws Exception {
            this.bytecode = byArray;
            ClassReader classReader = new ClassReader((InputStream)new ByteArrayInputStream(byArray));
            String[] stringArray = ClassNameReader.getClassInfo((ClassReader)classReader);
            this.name = stringArray[0];
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                if (!(class$net$sf$cglib$transform$impl$InterceptFieldEnabled == null ? InstrumentTask.class$("net.sf.cglib.transform.impl.InterceptFieldEnabled") : class$net$sf$cglib$transform$impl$InterceptFieldEnabled).getName().equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            this.isInstrumented = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInstrumented() {
            return this.isInstrumented;
        }

        public byte[] getBytes() {
            return this.bytecode;
        }
    }
}

