/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.util.ByteCodeHelper;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.hibernate.bytecode.util.FieldFilter;

public abstract class BasicInstrumentationTask
extends Task {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    protected final Logger logger = new Logger();
    private List filesets = new ArrayList();
    private Set classNames = new HashSet();
    private boolean extended;
    private boolean verbose;

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    protected final Iterator filesets() {
        return this.filesets.iterator();
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean bl) {
        this.extended = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void execute() throws BuildException {
        if (this.isExtended()) {
            this.collectClassNames();
        }
        this.logger.info("starting instrumentation");
        Project project = this.getProject();
        Iterator iterator = this.filesets();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            File file = fileSet.getDir(project);
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                try {
                    this.processFile(file2);
                    continue;
                }
                catch (Exception exception) {
                    throw new BuildException((Throwable)exception);
                }
            }
        }
    }

    private void collectClassNames() {
        this.logger.info("collecting class names for extended instrumentation determination");
        Project project = this.getProject();
        Iterator iterator = this.filesets();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            String[] stringArray = directoryScanner.getIncludedFiles();
            File file = fileSet.getDir(project);
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                try {
                    this.collectClassNames(file2);
                    continue;
                }
                catch (Exception exception) {
                    throw new BuildException((Throwable)exception);
                }
            }
        }
        this.logger.info(this.classNames.size() + " class(es) being checked");
    }

    private void collectClassNames(File file) throws Exception {
        if (this.isClassFile(file)) {
            byte[] byArray = ByteCodeHelper.readByteCode(file);
            ClassDescriptor classDescriptor = this.getClassDescriptor(byArray);
            this.classNames.add(classDescriptor.getName());
        } else if (this.isJarFile(file)) {
            ZipEntryHandler zipEntryHandler = new ZipEntryHandler(){

                public void handleEntry(ZipEntry zipEntry, byte[] byArray) throws Exception {
                    DataInputStream dataInputStream;
                    if (!zipEntry.isDirectory() && (dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray))).readInt() == -889275714) {
                        BasicInstrumentationTask.this.classNames.add(BasicInstrumentationTask.this.getClassDescriptor(byArray).getName());
                    }
                }
            };
            ZipFileProcessor zipFileProcessor = new ZipFileProcessor(zipEntryHandler);
            zipFileProcessor.process(file);
        }
    }

    protected void processFile(File file) throws Exception {
        if (this.isClassFile(file)) {
            this.processClassFile(file);
        } else if (this.isJarFile(file)) {
            this.processJarFile(file);
        } else {
            this.logger.verbose("ignoring " + file.toURL());
        }
    }

    protected final boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    protected final boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkMagic(File file, long l) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        try {
            int n = dataInputStream.readInt();
            boolean bl = l == (long)n;
            return bl;
        }
        finally {
            dataInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClassFile(File file) throws Exception {
        this.logger.verbose("Starting class file : " + file.toURL());
        byte[] byArray = ByteCodeHelper.readByteCode(file);
        ClassDescriptor classDescriptor = this.getClassDescriptor(byArray);
        ClassTransformer classTransformer = this.getClassTransformer(classDescriptor);
        if (classTransformer == null) {
            this.logger.verbose("skipping file : " + file.toURL());
            return;
        }
        this.logger.info("processing class [" + classDescriptor.getName() + "]; file = " + file.toURL());
        byte[] byArray2 = classTransformer.transform(((Object)((Object)this)).getClass().getClassLoader(), classDescriptor.getName(), null, null, classDescriptor.getBytes());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ((OutputStream)fileOutputStream).write(byArray2);
            fileOutputStream.flush();
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(final File file) throws Exception {
        block9: {
            this.logger.verbose("starting jar file : " + file.toURL());
            File file2 = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
            try {
                Object object;
                FileOutputStream fileOutputStream = new FileOutputStream(file2, false);
                try {
                    object = new ZipOutputStream(fileOutputStream);
                    ZipEntryHandler zipEntryHandler = new ZipEntryHandler((ZipOutputStream)object){
                        private final /* synthetic */ ZipOutputStream val$out;
                        {
                            this.val$out = zipOutputStream;
                        }

                        public void handleEntry(ZipEntry zipEntry, byte[] byArray) throws Exception {
                            Object object;
                            Object object2;
                            BasicInstrumentationTask.this.logger.verbose("starting entry : " + zipEntry.toString());
                            if (!zipEntry.isDirectory()) {
                                object2 = new DataInputStream(new ByteArrayInputStream(byArray));
                                if (((DataInputStream)object2).readInt() == -889275714) {
                                    object = BasicInstrumentationTask.this.getClassDescriptor(byArray);
                                    ClassTransformer classTransformer = BasicInstrumentationTask.this.getClassTransformer((ClassDescriptor)object);
                                    if (classTransformer == null) {
                                        BasicInstrumentationTask.this.logger.verbose("skipping entry : " + zipEntry.toString());
                                    } else {
                                        BasicInstrumentationTask.this.logger.info("processing class [" + object.getName() + "]; entry = " + file.toURL());
                                        byArray = classTransformer.transform(this.getClass().getClassLoader(), object.getName(), null, null, object.getBytes());
                                    }
                                } else {
                                    BasicInstrumentationTask.this.logger.verbose("ignoring zip entry : " + zipEntry.toString());
                                }
                            }
                            object2 = new ZipEntry(zipEntry.getName());
                            ((ZipEntry)object2).setMethod(zipEntry.getMethod());
                            ((ZipEntry)object2).setComment(zipEntry.getComment());
                            ((ZipEntry)object2).setSize(byArray.length);
                            if (((ZipEntry)object2).getMethod() == 0) {
                                object = new CRC32();
                                object.update(byArray);
                                ((ZipEntry)object2).setCrc(((CRC32)object).getValue());
                                ((ZipEntry)object2).setCompressedSize(byArray.length);
                            }
                            this.val$out.putNextEntry((ZipEntry)object2);
                            this.val$out.write(byArray);
                            this.val$out.closeEntry();
                        }
                    };
                    ZipFileProcessor zipFileProcessor = new ZipFileProcessor(zipEntryHandler);
                    zipFileProcessor.process(file);
                    ((ZipOutputStream)object).close();
                }
                finally {
                    fileOutputStream.close();
                }
                if (file.delete()) {
                    object = new File(file2.getAbsolutePath());
                    if (!((File)object).renameTo(file)) {
                        throw new IOException("can not rename " + file2 + " to " + file);
                    }
                    break block9;
                }
                throw new IOException("can not delete " + file);
            }
            finally {
                file2.delete();
            }
        }
    }

    protected boolean isBeingIntrumented(String string) {
        this.logger.verbose("checking to see if class [" + string + "] is set to be instrumented");
        return this.classNames.contains(string);
    }

    protected abstract ClassDescriptor getClassDescriptor(byte[] var1) throws Exception;

    protected abstract ClassTransformer getClassTransformer(ClassDescriptor var1);

    protected class CustomFieldFilter
    implements FieldFilter {
        private final ClassDescriptor descriptor;

        public CustomFieldFilter(ClassDescriptor classDescriptor) {
            this.descriptor = classDescriptor;
        }

        public boolean shouldInstrumentField(String string, String string2) {
            if (this.descriptor.getName().equals(string)) {
                BasicInstrumentationTask.this.logger.verbose("accepting transformation of field [" + string + "." + string2 + "]");
                return true;
            }
            BasicInstrumentationTask.this.logger.verbose("not accepting transformation of field [" + string + "." + string2 + "]");
            return false;
        }

        public boolean shouldTransformFieldAccess(String string, String string2, String string3) {
            if (this.descriptor.getName().equals(string2)) {
                BasicInstrumentationTask.this.logger.verbose("accepting transformation of field access [" + string2 + "." + string3 + "]");
                return true;
            }
            if (BasicInstrumentationTask.this.isExtended() && BasicInstrumentationTask.this.isBeingIntrumented(string2)) {
                BasicInstrumentationTask.this.logger.verbose("accepting extended transformation of field access [" + string2 + "." + string3 + "]");
                return true;
            }
            BasicInstrumentationTask.this.logger.verbose("not accepting transformation of field access [" + string2 + "." + string3 + "]");
            return false;
        }
    }

    protected class Logger {
        protected Logger() {
        }

        public void verbose(String string) {
            if (BasicInstrumentationTask.this.verbose) {
                System.out.println(string);
            } else {
                BasicInstrumentationTask.this.log(string, 3);
            }
        }

        public void debug(String string) {
            BasicInstrumentationTask.this.log(string, 4);
        }

        public void info(String string) {
            BasicInstrumentationTask.this.log(string, 2);
        }

        public void warn(String string) {
            BasicInstrumentationTask.this.log(string, 1);
        }
    }

    private static interface ZipEntryHandler {
        public void handleEntry(ZipEntry var1, byte[] var2) throws Exception;
    }

    private static class ZipFileProcessor {
        private final ZipEntryHandler entryHandler;

        public ZipFileProcessor(ZipEntryHandler zipEntryHandler) {
            this.entryHandler = zipEntryHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(File file) throws Exception {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    byte[] byArray = ByteCodeHelper.readByteCode(zipInputStream);
                    this.entryHandler.handleEntry(zipEntry, byArray);
                    zipInputStream.closeEntry();
                }
            }
            finally {
                zipInputStream.close();
            }
        }
    }
}

