/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaUpdate {
    private static final Log log = LogFactory.getLog((Class)SchemaUpdate.class);
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;
    private List exceptions;

    public SchemaUpdate(Configuration configuration) throws HibernateException {
        this(configuration, configuration.getProperties());
    }

    public SchemaUpdate(Configuration configuration, Properties properties) throws HibernateException {
        this.configuration = configuration;
        this.dialect = Dialect.getDialect(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(properties2);
        this.exceptions = new ArrayList();
    }

    public SchemaUpdate(Configuration configuration, Settings settings) throws HibernateException {
        this.configuration = configuration;
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.exceptions = new ArrayList();
    }

    public static void main(String[] stringArray) {
        try {
            Configuration configuration = new Configuration();
            boolean bl = true;
            boolean bl2 = true;
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    if (stringArray[i].equals("--quiet")) {
                        bl = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("--properties=")) {
                        string = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].startsWith("--config=")) {
                        configuration.configure(stringArray[i].substring(9));
                        continue;
                    }
                    if (stringArray[i].startsWith("--text")) {
                        bl2 = false;
                        continue;
                    }
                    if (!stringArray[i].startsWith("--naming=")) continue;
                    configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(stringArray[i].substring(9)).newInstance());
                    continue;
                }
                configuration.addFile(stringArray[i]);
            }
            if (string != null) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getProperties());
                properties.load(new FileInputStream(string));
                configuration.setProperties(properties);
            }
            new SchemaUpdate(configuration).execute(bl, bl2);
        }
        catch (Exception exception) {
            log.error((Object)"Error running schema update", (Throwable)exception);
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(boolean bl, boolean bl2) {
        block17: {
            DatabaseMetadata databaseMetadata;
            log.info((Object)"Running hbm2ddl schema update");
            Connection connection = null;
            Statement statement = null;
            this.exceptions.clear();
            try {
                log.info((Object)"fetching database metadata");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                databaseMetadata = new DatabaseMetadata(connection, this.dialect);
                statement = connection.createStatement();
            }
            catch (SQLException sQLException) {
                this.exceptions.add(sQLException);
                log.error((Object)"could not get database metadata", (Throwable)sQLException);
                throw sQLException;
            }
            log.info((Object)"updating schema");
            String[] stringArray = this.configuration.generateSchemaUpdateScript(this.dialect, databaseMetadata);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                try {
                    if (bl) {
                        System.out.println(string);
                    }
                    if (!bl2) continue;
                    log.debug((Object)string);
                    statement.executeUpdate(string);
                    continue;
                }
                catch (SQLException sQLException) {
                    this.exceptions.add(sQLException);
                    log.error((Object)("Unsuccessful: " + string));
                    log.error((Object)sQLException.getMessage());
                }
            }
            log.info((Object)"schema update complete");
            Object var11_12 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                this.connectionHelper.release();
            }
            catch (Exception exception) {
                this.exceptions.add(exception);
                log.error((Object)"Error closing connection", (Throwable)exception);
            }
            break block17;
            {
                catch (Exception exception) {
                    this.exceptions.add(exception);
                    log.error((Object)"could not complete schema update", (Throwable)exception);
                    Object var11_13 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        this.connectionHelper.release();
                    }
                    catch (Exception exception2) {
                        this.exceptions.add(exception2);
                        log.error((Object)"Error closing connection", (Throwable)exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    this.connectionHelper.release();
                }
                catch (Exception exception) {
                    this.exceptions.add(exception);
                    log.error((Object)"Error closing connection", (Throwable)exception);
                }
                throw throwable;
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }
}

