/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.pretty.DDLFormatter;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaExport {
    private static final Log log = LogFactory.getLog((Class)SchemaExport.class);
    private ConnectionHelper connectionHelper;
    private String[] dropSQL;
    private String[] createSQL;
    private String outputFile = null;
    private String importFile = "/import.sql";
    private Dialect dialect;
    private String delimiter;
    private final List exceptions = new ArrayList();
    private boolean haltOnError = false;
    private boolean format = true;

    public SchemaExport(Configuration configuration) throws HibernateException {
        this(configuration, configuration.getProperties());
    }

    public SchemaExport(Configuration configuration, Settings settings) throws HibernateException {
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.dropSQL = configuration.generateDropSchemaScript(this.dialect);
        this.createSQL = configuration.generateSchemaCreationScript(this.dialect);
        this.format = settings.isFormatSqlEnabled();
    }

    public SchemaExport(Configuration configuration, Properties properties) throws HibernateException {
        this.dialect = Dialect.getDialect(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        properties2.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(properties2);
        this.dropSQL = configuration.generateDropSchemaScript(this.dialect);
        this.createSQL = configuration.generateSchemaCreationScript(this.dialect);
        this.format = PropertiesHelper.getBoolean("hibernate.format_sql", properties2);
    }

    public SchemaExport(Configuration configuration, Connection connection) {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.dialect = Dialect.getDialect(configuration.getProperties());
        this.dropSQL = configuration.generateDropSchemaScript(this.dialect);
        this.createSQL = configuration.generateSchemaCreationScript(this.dialect);
    }

    public SchemaExport setOutputFile(String string) {
        this.outputFile = string;
        return this;
    }

    public SchemaExport setImportFile(String string) {
        this.importFile = string;
        return this;
    }

    public SchemaExport setDelimiter(String string) {
        this.delimiter = string;
        return this;
    }

    public void create(boolean bl, boolean bl2) {
        this.execute(bl, bl2, false, false);
    }

    public void drop(boolean bl, boolean bl2) {
        this.execute(bl, bl2, true, false);
    }

    private String format(String string) {
        return this.format ? new DDLFormatter(string).format() : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block32: {
            log.info((Object)"Running hbm2ddl schema export");
            Connection connection = null;
            Writer writer = null;
            InputStreamReader inputStreamReader = null;
            Statement statement = null;
            this.exceptions.clear();
            try {
                InputStream inputStream = ConfigHelper.getResourceAsStream(this.importFile);
                inputStreamReader = new InputStreamReader(inputStream);
            }
            catch (HibernateException hibernateException) {
                log.debug((Object)("import file not found: " + this.importFile));
            }
            if (this.outputFile != null) {
                log.info((Object)("writing generated schema to file: " + this.outputFile));
                writer = new FileWriter(this.outputFile);
            }
            if (bl2) {
                log.info((Object)"exporting generated schema to database");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                statement = connection.createStatement();
            }
            if (!bl4) {
                this.drop(bl, bl2, writer, statement);
            }
            if (!bl3) {
                this.create(bl, bl2, writer, statement);
                if (bl2 && inputStreamReader != null) {
                    this.importScript(inputStreamReader, statement);
                }
            }
            log.info((Object)"schema export complete");
            Object var11_12 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.connectionHelper.release();
                }
            }
            catch (Exception exception) {
                this.exceptions.add(exception);
                log.error((Object)"Could not close connection", (Throwable)exception);
            }
            try {
                if (writer != null) {
                    writer.close();
                }
                if (inputStreamReader != null) {
                    ((Reader)inputStreamReader).close();
                }
                break block32;
            }
            catch (IOException exception) {
                this.exceptions.add(exception);
                log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)exception);
            }
            break block32;
            {
                catch (Exception exception) {
                    this.exceptions.add(exception);
                    log.error((Object)"schema export unsuccessful", (Throwable)exception);
                    Object var11_13 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            this.connectionHelper.release();
                        }
                    }
                    catch (Exception exception2) {
                        this.exceptions.add(exception2);
                        log.error((Object)"Could not close connection", (Throwable)exception2);
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (inputStreamReader != null) {
                            ((Reader)inputStreamReader).close();
                        }
                        break block32;
                    }
                    catch (IOException exception2) {
                        this.exceptions.add(exception2);
                        log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionHelper.release();
                    }
                }
                catch (Exception exception) {
                    this.exceptions.add(exception);
                    log.error((Object)"Could not close connection", (Throwable)exception);
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (inputStreamReader != null) {
                        ((Reader)inputStreamReader).close();
                    }
                }
                catch (IOException exception) {
                    this.exceptions.add(exception);
                    log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)exception);
                }
                throw throwable;
            }
        }
    }

    private void importScript(Reader reader, Statement statement) throws IOException {
        log.info((Object)("Executing import script: " + this.importFile));
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        while (string != null) {
            try {
                String string2 = string.trim();
                if (!(string2.length() == 0 || string2.startsWith("--") || string2.startsWith("//") || string2.startsWith("/*"))) {
                    if (string2.endsWith(";")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    log.debug((Object)string2);
                    statement.execute(string2);
                }
            }
            catch (SQLException sQLException) {
                throw new JDBCException("Error during import script execution", sQLException);
            }
            string = bufferedReader.readLine();
        }
    }

    private void create(boolean bl, boolean bl2, Writer writer, Statement statement) throws IOException {
        for (int i = 0; i < this.createSQL.length; ++i) {
            try {
                this.execute(bl, bl2, writer, statement, this.createSQL[i]);
                continue;
            }
            catch (SQLException sQLException) {
                if (this.haltOnError) {
                    throw new JDBCException("Error during DDL export", sQLException);
                }
                this.exceptions.add(sQLException);
                log.error((Object)("Unsuccessful: " + this.createSQL[i]));
                log.error((Object)sQLException.getMessage());
            }
        }
    }

    private void drop(boolean bl, boolean bl2, Writer writer, Statement statement) throws IOException {
        for (int i = 0; i < this.dropSQL.length; ++i) {
            try {
                this.execute(bl, bl2, writer, statement, this.dropSQL[i]);
                continue;
            }
            catch (SQLException sQLException) {
                this.exceptions.add(sQLException);
                log.debug((Object)("Unsuccessful: " + this.dropSQL[i]));
                log.debug((Object)sQLException.getMessage());
            }
        }
    }

    private void execute(boolean bl, boolean bl2, Writer writer, Statement statement, String string) throws IOException, SQLException {
        String string2 = this.format(string);
        if (this.delimiter != null) {
            string2 = string2 + this.delimiter;
        }
        if (bl) {
            System.out.println(string2);
        }
        log.debug((Object)string2);
        if (this.outputFile != null) {
            writer.write(string2 + "\n");
        }
        if (bl2) {
            statement.executeUpdate(string);
            SQLWarning sQLWarning = statement.getWarnings();
            if (sQLWarning != null) {
                JDBCExceptionReporter.logAndClearWarnings(this.connectionHelper.getConnection());
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Configuration configuration = new Configuration();
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            String string = null;
            String string2 = "/import.sql";
            String string3 = null;
            boolean bl6 = false;
            String string4 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("--")) {
                    if (stringArray[i].equals("--quiet")) {
                        bl = false;
                        continue;
                    }
                    if (stringArray[i].equals("--drop")) {
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--create")) {
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--haltonerror")) {
                        bl4 = true;
                        continue;
                    }
                    if (stringArray[i].equals("--text")) {
                        bl5 = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("--output=")) {
                        string = stringArray[i].substring(9);
                        continue;
                    }
                    if (stringArray[i].startsWith("--import=")) {
                        string2 = stringArray[i].substring(9);
                        continue;
                    }
                    if (stringArray[i].startsWith("--properties=")) {
                        string3 = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].equals("--format")) {
                        bl6 = true;
                        continue;
                    }
                    if (stringArray[i].startsWith("--delimiter=")) {
                        string4 = stringArray[i].substring(12);
                        continue;
                    }
                    if (stringArray[i].startsWith("--config=")) {
                        configuration.configure(stringArray[i].substring(9));
                        continue;
                    }
                    if (!stringArray[i].startsWith("--naming=")) continue;
                    configuration.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(stringArray[i].substring(9)).newInstance());
                    continue;
                }
                String string5 = stringArray[i];
                if (string5.endsWith(".jar")) {
                    configuration.addJar(new File(string5));
                    continue;
                }
                configuration.addFile(string5);
            }
            if (string3 != null) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)configuration.getProperties());
                properties.load(new FileInputStream(string3));
                configuration.setProperties(properties);
            }
            SchemaExport schemaExport = new SchemaExport(configuration).setHaltOnError(bl4).setOutputFile(string).setImportFile(string2).setDelimiter(string4);
            if (bl6) {
                schemaExport.setFormat(true);
            }
            schemaExport.execute(bl, bl5, bl2, bl3);
        }
        catch (Exception exception) {
            log.error((Object)"Error creating schema ", (Throwable)exception);
            exception.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public SchemaExport setFormat(boolean bl) {
        this.format = bl;
        return this;
    }

    public SchemaExport setHaltOnError(boolean bl) {
        this.haltOnError = bl;
        return this;
    }
}

