/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.util.ArrayHelper;

public class StatisticsImpl
implements Statistics,
StatisticsImplementor {
    private static final Log log = LogFactory.getLog((Class)StatisticsImpl.class);
    private SessionFactoryImplementor sessionFactory;
    private boolean isStatisticsEnabled;
    private long startTime;
    private long sessionOpenCount;
    private long sessionCloseCount;
    private long flushCount;
    private long connectCount;
    private long prepareStatementCount;
    private long closeStatementCount;
    private long entityLoadCount;
    private long entityUpdateCount;
    private long entityInsertCount;
    private long entityDeleteCount;
    private long entityFetchCount;
    private long collectionLoadCount;
    private long collectionUpdateCount;
    private long collectionRemoveCount;
    private long collectionRecreateCount;
    private long collectionFetchCount;
    private long secondLevelCacheHitCount;
    private long secondLevelCacheMissCount;
    private long secondLevelCachePutCount;
    private long queryExecutionCount;
    private long queryExecutionMaxTime;
    private String queryExecutionMaxTimeQueryString;
    private long queryCacheHitCount;
    private long queryCacheMissCount;
    private long queryCachePutCount;
    private long commitedTransactionCount;
    private long transactionCount;
    private long optimisticFailureCount;
    private final Map secondLevelCacheStatistics = new HashMap();
    private final Map entityStatistics = new HashMap();
    private final Map collectionStatistics = new HashMap();
    private final Map queryStatistics = new HashMap();

    public StatisticsImpl() {
        this.clear();
    }

    public StatisticsImpl(SessionFactoryImplementor sessionFactoryImplementor) {
        this.clear();
        this.sessionFactory = sessionFactoryImplementor;
    }

    public synchronized void clear() {
        this.secondLevelCacheHitCount = 0L;
        this.secondLevelCacheMissCount = 0L;
        this.secondLevelCachePutCount = 0L;
        this.sessionCloseCount = 0L;
        this.sessionOpenCount = 0L;
        this.flushCount = 0L;
        this.connectCount = 0L;
        this.prepareStatementCount = 0L;
        this.closeStatementCount = 0L;
        this.entityDeleteCount = 0L;
        this.entityInsertCount = 0L;
        this.entityUpdateCount = 0L;
        this.entityLoadCount = 0L;
        this.entityFetchCount = 0L;
        this.collectionRemoveCount = 0L;
        this.collectionUpdateCount = 0L;
        this.collectionRecreateCount = 0L;
        this.collectionLoadCount = 0L;
        this.collectionFetchCount = 0L;
        this.queryExecutionCount = 0L;
        this.queryCacheHitCount = 0L;
        this.queryExecutionMaxTime = 0L;
        this.queryExecutionMaxTimeQueryString = null;
        this.queryCacheMissCount = 0L;
        this.queryCachePutCount = 0L;
        this.transactionCount = 0L;
        this.commitedTransactionCount = 0L;
        this.optimisticFailureCount = 0L;
        this.secondLevelCacheStatistics.clear();
        this.entityStatistics.clear();
        this.collectionStatistics.clear();
        this.queryStatistics.clear();
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void openSession() {
        ++this.sessionOpenCount;
    }

    public synchronized void closeSession() {
        ++this.sessionCloseCount;
    }

    public synchronized void flush() {
        ++this.flushCount;
    }

    public synchronized void connect() {
        ++this.connectCount;
    }

    public synchronized void loadEntity(String string) {
        ++this.entityLoadCount;
        ++this.getEntityStatistics((String)string).loadCount;
    }

    public synchronized void fetchEntity(String string) {
        ++this.entityFetchCount;
        ++this.getEntityStatistics((String)string).fetchCount;
    }

    public synchronized EntityStatistics getEntityStatistics(String string) {
        EntityStatistics entityStatistics = (EntityStatistics)this.entityStatistics.get(string);
        if (entityStatistics == null) {
            entityStatistics = new EntityStatistics(string);
            this.entityStatistics.put(string, entityStatistics);
        }
        return entityStatistics;
    }

    public synchronized void updateEntity(String string) {
        ++this.entityUpdateCount;
        EntityStatistics entityStatistics = this.getEntityStatistics(string);
        ++entityStatistics.updateCount;
    }

    public synchronized void insertEntity(String string) {
        ++this.entityInsertCount;
        EntityStatistics entityStatistics = this.getEntityStatistics(string);
        ++entityStatistics.insertCount;
    }

    public synchronized void deleteEntity(String string) {
        ++this.entityDeleteCount;
        EntityStatistics entityStatistics = this.getEntityStatistics(string);
        ++entityStatistics.deleteCount;
    }

    public synchronized CollectionStatistics getCollectionStatistics(String string) {
        CollectionStatistics collectionStatistics = (CollectionStatistics)this.collectionStatistics.get(string);
        if (collectionStatistics == null) {
            collectionStatistics = new CollectionStatistics(string);
            this.collectionStatistics.put(string, collectionStatistics);
        }
        return collectionStatistics;
    }

    public synchronized void loadCollection(String string) {
        ++this.collectionLoadCount;
        ++this.getCollectionStatistics((String)string).loadCount;
    }

    public synchronized void fetchCollection(String string) {
        ++this.collectionFetchCount;
        ++this.getCollectionStatistics((String)string).fetchCount;
    }

    public synchronized void updateCollection(String string) {
        ++this.collectionUpdateCount;
        ++this.getCollectionStatistics((String)string).updateCount;
    }

    public synchronized void recreateCollection(String string) {
        ++this.collectionRecreateCount;
        ++this.getCollectionStatistics((String)string).recreateCount;
    }

    public synchronized void removeCollection(String string) {
        ++this.collectionRemoveCount;
        ++this.getCollectionStatistics((String)string).removeCount;
    }

    public synchronized SecondLevelCacheStatistics getSecondLevelCacheStatistics(String string) {
        SecondLevelCacheStatistics secondLevelCacheStatistics = (SecondLevelCacheStatistics)this.secondLevelCacheStatistics.get(string);
        if (secondLevelCacheStatistics == null) {
            if (this.sessionFactory == null) {
                return null;
            }
            Cache cache = this.sessionFactory.getSecondLevelCacheRegion(string);
            if (cache == null) {
                return null;
            }
            secondLevelCacheStatistics = new SecondLevelCacheStatistics(cache);
            this.secondLevelCacheStatistics.put(string, secondLevelCacheStatistics);
        }
        return secondLevelCacheStatistics;
    }

    public synchronized void secondLevelCachePut(String string) {
        ++this.secondLevelCachePutCount;
        ++this.getSecondLevelCacheStatistics((String)string).putCount;
    }

    public synchronized void secondLevelCacheHit(String string) {
        ++this.secondLevelCacheHitCount;
        ++this.getSecondLevelCacheStatistics((String)string).hitCount;
    }

    public synchronized void secondLevelCacheMiss(String string) {
        ++this.secondLevelCacheMissCount;
        ++this.getSecondLevelCacheStatistics((String)string).missCount;
    }

    public synchronized void queryExecuted(String string, int n, long l) {
        ++this.queryExecutionCount;
        if (this.queryExecutionMaxTime < l) {
            this.queryExecutionMaxTime = l;
            this.queryExecutionMaxTimeQueryString = string;
        }
        if (string != null) {
            QueryStatistics queryStatistics = this.getQueryStatistics(string);
            queryStatistics.executed(n, l);
        }
    }

    public synchronized void queryCacheHit(String string, String string2) {
        CategorizedStatistics categorizedStatistics;
        ++this.queryCacheHitCount;
        if (string != null) {
            categorizedStatistics = this.getQueryStatistics(string);
            ++categorizedStatistics.cacheHitCount;
        }
        categorizedStatistics = this.getSecondLevelCacheStatistics(string2);
        ++((SecondLevelCacheStatistics)categorizedStatistics).hitCount;
    }

    public synchronized void queryCacheMiss(String string, String string2) {
        CategorizedStatistics categorizedStatistics;
        ++this.queryCacheMissCount;
        if (string != null) {
            categorizedStatistics = this.getQueryStatistics(string);
            ++categorizedStatistics.cacheMissCount;
        }
        categorizedStatistics = this.getSecondLevelCacheStatistics(string2);
        ++((SecondLevelCacheStatistics)categorizedStatistics).missCount;
    }

    public synchronized void queryCachePut(String string, String string2) {
        CategorizedStatistics categorizedStatistics;
        ++this.queryCachePutCount;
        if (string != null) {
            categorizedStatistics = this.getQueryStatistics(string);
            ++categorizedStatistics.cachePutCount;
        }
        categorizedStatistics = this.getSecondLevelCacheStatistics(string2);
        ++((SecondLevelCacheStatistics)categorizedStatistics).putCount;
    }

    public synchronized QueryStatistics getQueryStatistics(String string) {
        QueryStatistics queryStatistics = (QueryStatistics)this.queryStatistics.get(string);
        if (queryStatistics == null) {
            queryStatistics = new QueryStatistics(string);
            this.queryStatistics.put(string, queryStatistics);
        }
        return queryStatistics;
    }

    public long getEntityDeleteCount() {
        return this.entityDeleteCount;
    }

    public long getEntityInsertCount() {
        return this.entityInsertCount;
    }

    public long getEntityLoadCount() {
        return this.entityLoadCount;
    }

    public long getEntityFetchCount() {
        return this.entityFetchCount;
    }

    public long getEntityUpdateCount() {
        return this.entityUpdateCount;
    }

    public long getQueryExecutionCount() {
        return this.queryExecutionCount;
    }

    public long getQueryCacheHitCount() {
        return this.queryCacheHitCount;
    }

    public long getQueryCacheMissCount() {
        return this.queryCacheMissCount;
    }

    public long getQueryCachePutCount() {
        return this.queryCachePutCount;
    }

    public long getFlushCount() {
        return this.flushCount;
    }

    public long getConnectCount() {
        return this.connectCount;
    }

    public long getSecondLevelCacheHitCount() {
        return this.secondLevelCacheHitCount;
    }

    public long getSecondLevelCacheMissCount() {
        return this.secondLevelCacheMissCount;
    }

    public long getSecondLevelCachePutCount() {
        return this.secondLevelCachePutCount;
    }

    public long getSessionCloseCount() {
        return this.sessionCloseCount;
    }

    public long getSessionOpenCount() {
        return this.sessionOpenCount;
    }

    public long getCollectionLoadCount() {
        return this.collectionLoadCount;
    }

    public long getCollectionFetchCount() {
        return this.collectionFetchCount;
    }

    public long getCollectionUpdateCount() {
        return this.collectionUpdateCount;
    }

    public long getCollectionRemoveCount() {
        return this.collectionRemoveCount;
    }

    public long getCollectionRecreateCount() {
        return this.collectionRecreateCount;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void logSummary() {
        log.info((Object)"Logging statistics....");
        log.info((Object)("start time: " + this.startTime));
        log.info((Object)("sessions opened: " + this.sessionOpenCount));
        log.info((Object)("sessions closed: " + this.sessionCloseCount));
        log.info((Object)("transactions: " + this.transactionCount));
        log.info((Object)("successful transactions: " + this.commitedTransactionCount));
        log.info((Object)("optimistic lock failures: " + this.optimisticFailureCount));
        log.info((Object)("flushes: " + this.flushCount));
        log.info((Object)("connections obtained: " + this.connectCount));
        log.info((Object)("statements prepared: " + this.prepareStatementCount));
        log.info((Object)("statements closed: " + this.closeStatementCount));
        log.info((Object)("second level cache puts: " + this.secondLevelCachePutCount));
        log.info((Object)("second level cache hits: " + this.secondLevelCacheHitCount));
        log.info((Object)("second level cache misses: " + this.secondLevelCacheMissCount));
        log.info((Object)("entities loaded: " + this.entityLoadCount));
        log.info((Object)("entities updated: " + this.entityUpdateCount));
        log.info((Object)("entities inserted: " + this.entityInsertCount));
        log.info((Object)("entities deleted: " + this.entityDeleteCount));
        log.info((Object)("entities fetched (minimize this): " + this.entityFetchCount));
        log.info((Object)("collections loaded: " + this.collectionLoadCount));
        log.info((Object)("collections updated: " + this.collectionUpdateCount));
        log.info((Object)("collections removed: " + this.collectionRemoveCount));
        log.info((Object)("collections recreated: " + this.collectionRecreateCount));
        log.info((Object)("collections fetched (minimize this): " + this.collectionFetchCount));
        log.info((Object)("queries executed to database: " + this.queryExecutionCount));
        log.info((Object)("query cache puts: " + this.queryCachePutCount));
        log.info((Object)("query cache hits: " + this.queryCacheHitCount));
        log.info((Object)("query cache misses: " + this.queryCacheMissCount));
        log.info((Object)("max query time: " + this.queryExecutionMaxTime + "ms"));
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setStatisticsEnabled(boolean bl) {
        this.isStatisticsEnabled = bl;
    }

    public long getQueryExecutionMaxTime() {
        return this.queryExecutionMaxTime;
    }

    public String[] getQueries() {
        return ArrayHelper.toStringArray(this.queryStatistics.keySet());
    }

    public String[] getEntityNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.entityStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllClassMetadata().keySet());
    }

    public String[] getCollectionRoleNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.collectionStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllCollectionMetadata().keySet());
    }

    public String[] getSecondLevelCacheRegionNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.secondLevelCacheStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllSecondLevelCacheRegions().keySet());
    }

    public void endTransaction(boolean bl) {
        ++this.transactionCount;
        if (bl) {
            ++this.commitedTransactionCount;
        }
    }

    public long getSuccessfulTransactionCount() {
        return this.commitedTransactionCount;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public void closeStatement() {
        ++this.closeStatementCount;
    }

    public void prepareStatement() {
        ++this.prepareStatementCount;
    }

    public long getCloseStatementCount() {
        return this.closeStatementCount;
    }

    public long getPrepareStatementCount() {
        return this.prepareStatementCount;
    }

    public void optimisticFailure(String string) {
        ++this.optimisticFailureCount;
        ++this.getEntityStatistics((String)string).optimisticFailureCount;
    }

    public long getOptimisticFailureCount() {
        return this.optimisticFailureCount;
    }

    public String toString() {
        return "Statistics[" + "start time=" + this.startTime + ",sessions opened=" + this.sessionOpenCount + ",sessions closed=" + this.sessionCloseCount + ",transactions=" + this.transactionCount + ",successful transactions=" + this.commitedTransactionCount + ",optimistic lock failures=" + this.optimisticFailureCount + ",flushes=" + this.flushCount + ",connections obtained=" + this.connectCount + ",statements prepared=" + this.prepareStatementCount + ",statements closed=" + this.closeStatementCount + ",second level cache puts=" + this.secondLevelCachePutCount + ",second level cache hits=" + this.secondLevelCacheHitCount + ",second level cache misses=" + this.secondLevelCacheMissCount + ",entities loaded=" + this.entityLoadCount + ",entities updated=" + this.entityUpdateCount + ",entities inserted=" + this.entityInsertCount + ",entities deleted=" + this.entityDeleteCount + ",entities fetched=" + this.entityFetchCount + ",collections loaded=" + this.collectionLoadCount + ",collections updated=" + this.collectionUpdateCount + ",collections removed=" + this.collectionRemoveCount + ",collections recreated=" + this.collectionRecreateCount + ",collections fetched=" + this.collectionFetchCount + ",queries executed to database=" + this.queryExecutionCount + ",query cache puts=" + this.queryCachePutCount + ",query cache hits=" + this.queryCacheHitCount + ",query cache misses=" + this.queryCacheMissCount + ",max query time=" + this.queryExecutionMaxTime + ']';
    }

    public String getQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }
}

