/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;

public final class Template {
    private static final Set KEYWORDS = new HashSet();
    private static final Set BEFORE_TABLE_KEYWORDS = new HashSet();
    private static final Set FUNCTION_KEYWORDS = new HashSet();
    public static final String TEMPLATE = "$PlaceHolder$";

    private Template() {
    }

    public static String renderWhereStringTemplate(String string, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        return Template.renderWhereStringTemplate(string, TEMPLATE, dialect, sQLFunctionRegistry);
    }

    public static String renderWhereStringTemplate(String string, String string2, Dialect dialect) {
        return Template.renderWhereStringTemplate(string, string2, dialect, new SQLFunctionRegistry(dialect, Collections.EMPTY_MAP));
    }

    public static String renderWhereStringTemplate(String string, String string2, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        String string3;
        String string4 = "=><!+-*/()',|&`" + " \n\r\f\t" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4, true);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = stringTokenizer.hasMoreTokens();
        String string5 = string3 = bl6 ? stringTokenizer.nextToken() : null;
        while (bl6) {
            boolean bl7;
            String string6 = string3;
            String string7 = string6.toLowerCase();
            bl6 = stringTokenizer.hasMoreTokens();
            string3 = bl6 ? stringTokenizer.nextToken() : null;
            boolean bl8 = false;
            if (!bl2 && "'".equals(string6)) {
                bl = !bl;
                bl8 = true;
            }
            if (!bl) {
                if ("`".equals(string6)) {
                    bl7 = !bl2;
                    string7 = bl7 ? new Character(dialect.openQuote()).toString() : new Character(dialect.closeQuote()).toString();
                    string6 = string7;
                    bl2 = bl7;
                    bl8 = true;
                } else if (!bl2 && dialect.openQuote() == string6.charAt(0)) {
                    bl7 = true;
                    bl2 = true;
                    bl8 = true;
                } else if (bl2 && dialect.closeQuote() == string6.charAt(0)) {
                    bl2 = false;
                    bl8 = true;
                    bl7 = false;
                } else {
                    bl7 = false;
                }
                if (bl7) {
                    stringBuffer.append(string2).append('.');
                }
            }
            boolean bl9 = bl7 = bl || bl2 || bl8 || Character.isWhitespace(string6.charAt(0));
            if (bl7) {
                stringBuffer.append(string6);
            } else if (bl3) {
                stringBuffer.append(string6);
                bl3 = false;
                bl5 = true;
            } else if (bl5) {
                if (!"as".equals(string7)) {
                    bl5 = false;
                }
                stringBuffer.append(string6);
            } else if (Template.isNamedParameter(string6)) {
                stringBuffer.append(string6);
            } else if (Template.isIdentifier(string6, dialect) && !Template.isFunctionOrKeyword(string7, string3, dialect, sQLFunctionRegistry)) {
                stringBuffer.append(string2).append('.').append(dialect.quote(string6));
            } else {
                if (BEFORE_TABLE_KEYWORDS.contains(string7)) {
                    bl3 = true;
                    bl4 = true;
                } else if (bl4 && ",".equals(string7)) {
                    bl3 = true;
                }
                stringBuffer.append(string6);
            }
            if (!bl4 || !KEYWORDS.contains(string7) || BEFORE_TABLE_KEYWORDS.contains(string7)) continue;
            bl4 = false;
        }
        return stringBuffer.toString();
    }

    public static String renderOrderByStringTemplate(String string, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        String string2;
        String string3 = "=><!+-*/()',|&`" + " \n\r\f\t" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3, true);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = stringTokenizer.hasMoreTokens();
        String string4 = string2 = bl3 ? stringTokenizer.nextToken() : null;
        while (bl3) {
            boolean bl4;
            String string5 = string2;
            String string6 = string5.toLowerCase();
            bl3 = stringTokenizer.hasMoreTokens();
            string2 = bl3 ? stringTokenizer.nextToken() : null;
            boolean bl5 = false;
            if (!bl2 && "'".equals(string5)) {
                bl = !bl;
                bl5 = true;
            }
            if (!bl) {
                if ("`".equals(string5)) {
                    bl4 = !bl2;
                    string6 = bl4 ? new Character(dialect.openQuote()).toString() : new Character(dialect.closeQuote()).toString();
                    string5 = string6;
                    bl2 = bl4;
                    bl5 = true;
                } else if (!bl2 && dialect.openQuote() == string5.charAt(0)) {
                    bl4 = true;
                    bl2 = true;
                    bl5 = true;
                } else if (bl2 && dialect.closeQuote() == string5.charAt(0)) {
                    bl2 = false;
                    bl5 = true;
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    stringBuffer.append(TEMPLATE).append('.');
                }
            }
            boolean bl6 = bl4 = bl || bl2 || bl5 || Character.isWhitespace(string5.charAt(0));
            if (bl4) {
                stringBuffer.append(string5);
                continue;
            }
            if (Template.isIdentifier(string5, dialect) && !Template.isFunctionOrKeyword(string6, string2, dialect, sQLFunctionRegistry)) {
                stringBuffer.append(TEMPLATE).append('.').append(dialect.quote(string5));
                continue;
            }
            stringBuffer.append(string5);
        }
        return stringBuffer.toString();
    }

    private static boolean isNamedParameter(String string) {
        return string.startsWith(":");
    }

    private static boolean isFunctionOrKeyword(String string, String string2, Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        return "(".equals(string2) || KEYWORDS.contains(string) || sQLFunctionRegistry.hasFunction(string) || dialect.getKeywords().contains(string) || FUNCTION_KEYWORDS.contains(string);
    }

    private static boolean isIdentifier(String string, Dialect dialect) {
        return string.charAt(0) == '`' || Character.isLetter(string.charAt(0)) && string.indexOf(46) < 0;
    }

    static {
        KEYWORDS.add("and");
        KEYWORDS.add("or");
        KEYWORDS.add("not");
        KEYWORDS.add("like");
        KEYWORDS.add("is");
        KEYWORDS.add("in");
        KEYWORDS.add("between");
        KEYWORDS.add("null");
        KEYWORDS.add("select");
        KEYWORDS.add("distinct");
        KEYWORDS.add("from");
        KEYWORDS.add("join");
        KEYWORDS.add("inner");
        KEYWORDS.add("outer");
        KEYWORDS.add("left");
        KEYWORDS.add("right");
        KEYWORDS.add("on");
        KEYWORDS.add("where");
        KEYWORDS.add("having");
        KEYWORDS.add("group");
        KEYWORDS.add("order");
        KEYWORDS.add("by");
        KEYWORDS.add("desc");
        KEYWORDS.add("asc");
        KEYWORDS.add("limit");
        KEYWORDS.add("any");
        KEYWORDS.add("some");
        KEYWORDS.add("exists");
        KEYWORDS.add("all");
        BEFORE_TABLE_KEYWORDS.add("from");
        BEFORE_TABLE_KEYWORDS.add("join");
        FUNCTION_KEYWORDS.add("as");
        FUNCTION_KEYWORDS.add("leading");
        FUNCTION_KEYWORDS.add("trailing");
        FUNCTION_KEYWORDS.add("from");
        FUNCTION_KEYWORDS.add("case");
        FUNCTION_KEYWORDS.add("when");
        FUNCTION_KEYWORDS.add("then");
        FUNCTION_KEYWORDS.add("else");
        FUNCTION_KEYWORDS.add("end");
    }
}

