/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;

public class SimpleSelect {
    private String tableName;
    private String orderBy;
    private Dialect dialect;
    private LockMode lockMode = LockMode.READ;
    private String comment;
    private List columns = new ArrayList();
    private Map aliases = new HashMap();
    private List whereTokens = new ArrayList();

    public SimpleSelect(Dialect dialect) {
        this.dialect = dialect;
    }

    public SimpleSelect addColumns(String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public SimpleSelect addColumns(String[] stringArray, String[] stringArray2, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] || stringArray[i] == null) continue;
            this.addColumn(stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public SimpleSelect addColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addColumn(stringArray[i]);
        }
        return this;
    }

    public SimpleSelect addColumn(String string) {
        this.columns.add(string);
        return this;
    }

    public SimpleSelect addColumn(String string, String string2) {
        this.columns.add(string);
        this.aliases.put(string, string2);
        return this;
    }

    public SimpleSelect setTableName(String string) {
        this.tableName = string;
        return this;
    }

    public SimpleSelect setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public SimpleSelect addWhereToken(String string) {
        this.whereTokens.add(string);
        return this;
    }

    private void and() {
        if (this.whereTokens.size() > 0) {
            this.whereTokens.add("and");
        }
    }

    public SimpleSelect addCondition(String string, String string2, String string3) {
        this.and();
        this.whereTokens.add(string + ' ' + string2 + ' ' + string3);
        return this;
    }

    public SimpleSelect addCondition(String string, String string2) {
        this.and();
        this.whereTokens.add(string + ' ' + string2);
        return this;
    }

    public SimpleSelect addCondition(String[] stringArray, String string, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addCondition(stringArray[i], string, stringArray2[i]);
        }
        return this;
    }

    public SimpleSelect addCondition(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addCondition(stringArray[i], string);
        }
        return this;
    }

    public String toStatementString() {
        StringBuffer stringBuffer = new StringBuffer(this.columns.size() * 10 + this.tableName.length() + this.whereTokens.size() * 10 + 10);
        if (this.comment != null) {
            stringBuffer.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuffer.append("select ");
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.columns.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.aliases.get(string);
            if (!hashSet.add(string2 == null ? string : string2)) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            if (string2 != null && !string2.equals(string)) {
                stringBuffer.append(" as ").append(string2);
            }
            bl = true;
        }
        stringBuffer.append(" from ").append(this.dialect.appendLockHint(this.lockMode, this.tableName));
        if (this.whereTokens.size() > 0) {
            stringBuffer.append(" where ").append(this.toWhereClause());
        }
        if (this.orderBy != null) {
            stringBuffer.append(this.orderBy);
        }
        if (this.lockMode != null) {
            stringBuffer.append(this.dialect.getForUpdateString(this.lockMode));
        }
        return this.dialect.transformSelectString(stringBuffer.toString());
    }

    public String toWhereClause() {
        StringBuffer stringBuffer = new StringBuffer(this.whereTokens.size() * 5);
        Iterator iterator = this.whereTokens.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public SimpleSelect setOrderBy(String string) {
        this.orderBy = string;
        return this;
    }

    public SimpleSelect setComment(String string) {
        this.comment = string;
        return this;
    }
}

