/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hibernate.sql.Alias;
import org.hibernate.sql.CaseFragment;
import org.hibernate.util.StringHelper;

public class SelectFragment {
    private String suffix;
    private List columns = new ArrayList();
    private List columnAliases = new ArrayList();
    private String extraSelectList;
    private String[] usedAliases;

    public SelectFragment setUsedAliases(String[] stringArray) {
        this.usedAliases = stringArray;
        return this;
    }

    public SelectFragment setExtraSelectList(String string) {
        this.extraSelectList = string;
        return this;
    }

    public SelectFragment setExtraSelectList(CaseFragment caseFragment, String string) {
        this.setExtraSelectList(caseFragment.setReturnColumnName(string, this.suffix).toFragmentString());
        return this;
    }

    public SelectFragment setSuffix(String string) {
        this.suffix = string;
        return this;
    }

    public SelectFragment addColumn(String string) {
        this.addColumn(null, string);
        return this;
    }

    public SelectFragment addColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addColumn(stringArray[i]);
        }
        return this;
    }

    public SelectFragment addColumn(String string, String string2) {
        return this.addColumn(string, string2, string2);
    }

    public SelectFragment addColumn(String string, String string2, String string3) {
        this.columns.add(StringHelper.qualify(string, string2));
        this.columnAliases.add(string3);
        return this;
    }

    public SelectFragment addColumns(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addColumn(string, stringArray[i]);
        }
        return this;
    }

    public SelectFragment addColumns(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addColumn(string, stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public SelectFragment addFormulas(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.addFormula(string, stringArray[i], stringArray2[i]);
        }
        return this;
    }

    public SelectFragment addFormula(String string, String string2, String string3) {
        this.columns.add(StringHelper.replace(string2, "$PlaceHolder$", string));
        this.columnAliases.add(string3);
        return this;
    }

    public String toFragmentString() {
        StringBuffer stringBuffer = new StringBuffer(this.columns.size() * 10);
        Iterator iterator = this.columns.iterator();
        Iterator iterator2 = this.columnAliases.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        if (this.usedAliases != null) {
            hashSet.addAll(Arrays.asList(this.usedAliases));
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)iterator2.next();
            if (!hashSet.add(string2)) continue;
            stringBuffer.append(", ").append(string).append(" as ");
            if (this.suffix == null) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(new Alias(this.suffix).toAliasString(string2));
        }
        if (this.extraSelectList != null) {
            stringBuffer.append(", ").append(this.extraSelectList);
        }
        return stringBuffer.toString();
    }
}

