/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.StringHelper;

public class Select {
    private String selectClause;
    private String fromClause;
    private String outerJoinsAfterFrom;
    private String whereClause;
    private String outerJoinsAfterWhere;
    private String orderByClause;
    private String groupByClause;
    private String comment;
    private LockMode lockMode;
    public final Dialect dialect;
    private int guesstimatedBufferSize = 20;

    public Select(Dialect dialect) {
        this.dialect = dialect;
    }

    public String toStatementString() {
        StringBuffer stringBuffer = new StringBuffer(this.guesstimatedBufferSize);
        if (StringHelper.isNotEmpty(this.comment)) {
            stringBuffer.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuffer.append("select ").append(this.selectClause).append(" from ").append(this.fromClause);
        if (StringHelper.isNotEmpty(this.outerJoinsAfterFrom)) {
            stringBuffer.append(this.outerJoinsAfterFrom);
        }
        if (StringHelper.isNotEmpty(this.whereClause) || StringHelper.isNotEmpty(this.outerJoinsAfterWhere)) {
            stringBuffer.append(" where ");
            if (StringHelper.isNotEmpty(this.outerJoinsAfterWhere)) {
                stringBuffer.append(this.outerJoinsAfterWhere);
                if (StringHelper.isNotEmpty(this.whereClause)) {
                    stringBuffer.append(" and ");
                }
            }
            if (StringHelper.isNotEmpty(this.whereClause)) {
                stringBuffer.append(this.whereClause);
            }
        }
        if (StringHelper.isNotEmpty(this.groupByClause)) {
            stringBuffer.append(" group by ").append(this.groupByClause);
        }
        if (StringHelper.isNotEmpty(this.orderByClause)) {
            stringBuffer.append(" order by ").append(this.orderByClause);
        }
        if (this.lockMode != null) {
            stringBuffer.append(this.dialect.getForUpdateString(this.lockMode));
        }
        return this.dialect.transformSelectString(stringBuffer.toString());
    }

    public Select setFromClause(String string) {
        this.fromClause = string;
        this.guesstimatedBufferSize += string.length();
        return this;
    }

    public Select setFromClause(String string, String string2) {
        this.fromClause = string + ' ' + string2;
        this.guesstimatedBufferSize += this.fromClause.length();
        return this;
    }

    public Select setOrderByClause(String string) {
        this.orderByClause = string;
        this.guesstimatedBufferSize += string.length();
        return this;
    }

    public Select setGroupByClause(String string) {
        this.groupByClause = string;
        this.guesstimatedBufferSize += string.length();
        return this;
    }

    public Select setOuterJoins(String string, String string2) {
        this.outerJoinsAfterFrom = string;
        String string3 = string2.trim();
        if (string3.startsWith("and")) {
            string3 = string3.substring(4);
        }
        this.outerJoinsAfterWhere = string3;
        this.guesstimatedBufferSize += string.length() + string2.length();
        return this;
    }

    public Select setSelectClause(String string) {
        this.selectClause = string;
        this.guesstimatedBufferSize += string.length();
        return this;
    }

    public Select setWhereClause(String string) {
        this.whereClause = string;
        this.guesstimatedBufferSize += string.length();
        return this;
    }

    public Select setComment(String string) {
        this.comment = string;
        this.guesstimatedBufferSize += string.length();
        return this;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public Select setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }
}

