/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import org.hibernate.dialect.Dialect;
import org.hibernate.sql.JoinFragment;

public class QueryJoinFragment
extends JoinFragment {
    private StringBuffer afterFrom = new StringBuffer();
    private StringBuffer afterWhere = new StringBuffer();
    private Dialect dialect;
    private boolean useThetaStyleInnerJoins;

    public QueryJoinFragment(Dialect dialect, boolean bl) {
        this.dialect = dialect;
        this.useThetaStyleInnerJoins = bl;
    }

    public void addJoin(String string, String string2, String[] stringArray, String[] stringArray2, int n) {
        this.addJoin(string, string2, string2, stringArray, stringArray2, n, null);
    }

    public void addJoin(String string, String string2, String[] stringArray, String[] stringArray2, int n, String string3) {
        this.addJoin(string, string2, string2, stringArray, stringArray2, n, string3);
    }

    private void addJoin(String string, String string2, String string3, String[] stringArray, String[] stringArray2, int n, String string4) {
        if (!this.useThetaStyleInnerJoins || n != 0) {
            JoinFragment joinFragment = this.dialect.createOuterJoinFragment();
            joinFragment.addJoin(string, string2, stringArray, stringArray2, n, string4);
            this.addFragment(joinFragment);
        } else {
            this.addCrossJoin(string, string2);
            this.addCondition(string3, stringArray, stringArray2);
            this.addCondition(string4);
        }
    }

    public String toFromFragmentString() {
        return this.afterFrom.toString();
    }

    public String toWhereFragmentString() {
        return this.afterWhere.toString();
    }

    public void addJoins(String string, String string2) {
        this.afterFrom.append(string);
        this.afterWhere.append(string2);
    }

    public JoinFragment copy() {
        QueryJoinFragment queryJoinFragment = new QueryJoinFragment(this.dialect, this.useThetaStyleInnerJoins);
        queryJoinFragment.afterFrom = new StringBuffer(this.afterFrom.toString());
        queryJoinFragment.afterWhere = new StringBuffer(this.afterWhere.toString());
        return queryJoinFragment;
    }

    public void addCondition(String string, String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.afterWhere.append(" and ").append(string).append('.').append(stringArray[i]).append(string2);
        }
    }

    public void addCrossJoin(String string, String string2) {
        this.afterFrom.append(", ").append(string).append(' ').append(string2);
    }

    public void addCondition(String string, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.afterWhere.append(" and ").append(stringArray[i]).append('=').append(string).append('.').append(stringArray2[i]);
        }
    }

    public boolean addCondition(String string) {
        if (this.afterFrom.toString().indexOf(string.trim()) < 0 && this.afterWhere.toString().indexOf(string.trim()) < 0) {
            if (!string.startsWith(" and ")) {
                this.afterWhere.append(" and ");
            }
            this.afterWhere.append(string);
            return true;
        }
        return false;
    }

    public void addFromFragmentString(String string) {
        this.afterFrom.append(string);
    }

    public void clearWherePart() {
        this.afterWhere.setLength(0);
    }
}

