/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.Select;

public class InsertSelect {
    private Dialect dialect;
    private String tableName;
    private String comment;
    private List columnNames = new ArrayList();
    private Select select;

    public InsertSelect(Dialect dialect) {
        this.dialect = dialect;
    }

    public InsertSelect setTableName(String string) {
        this.tableName = string;
        return this;
    }

    public InsertSelect setComment(String string) {
        this.comment = string;
        return this;
    }

    public InsertSelect addColumn(String string) {
        this.columnNames.add(string);
        return this;
    }

    public InsertSelect addColumns(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnNames.add(stringArray[i]);
        }
        return this;
    }

    public InsertSelect setSelect(Select select) {
        this.select = select;
        return this;
    }

    public String toStatementString() {
        if (this.tableName == null) {
            throw new HibernateException("no table name defined for insert-select");
        }
        if (this.select == null) {
            throw new HibernateException("no select defined for insert-select");
        }
        StringBuffer stringBuffer = new StringBuffer(this.columnNames.size() * 15 + this.tableName.length() + 10);
        if (this.comment != null) {
            stringBuffer.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuffer.append("insert into ").append(this.tableName);
        if (!this.columnNames.isEmpty()) {
            stringBuffer.append(" (");
            Iterator iterator = this.columnNames.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(' ').append(this.select.toStatementString());
        return stringBuffer.toString();
    }
}

