/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.StringHelper;

public class ForUpdateFragment {
    private final StringBuffer aliases = new StringBuffer();
    private boolean isNowaitEnabled;
    private final Dialect dialect;

    public ForUpdateFragment(Dialect dialect) {
        this.dialect = dialect;
    }

    public ForUpdateFragment(Dialect dialect, Map map, Map map2) throws QueryException {
        this(dialect);
        LockMode lockMode = null;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LockMode lockMode2 = (LockMode)entry.getValue();
            if (!LockMode.READ.lessThan(lockMode2)) continue;
            String string = (String)entry.getKey();
            if (dialect.forUpdateOfColumns()) {
                String[] stringArray = (String[])map2.get(string);
                if (stringArray == null) {
                    throw new IllegalArgumentException("alias not found: " + string);
                }
                stringArray = StringHelper.qualify(string, stringArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addTableAlias(stringArray[i]);
                }
            } else {
                this.addTableAlias(string);
            }
            if (lockMode != null && lockMode2 != lockMode) {
                throw new QueryException("mixed LockModes");
            }
            lockMode = lockMode2;
        }
        if (lockMode == LockMode.UPGRADE_NOWAIT) {
            this.setNowaitEnabled(true);
        }
    }

    public ForUpdateFragment addTableAlias(String string) {
        if (this.aliases.length() > 0) {
            this.aliases.append(", ");
        }
        this.aliases.append(string);
        return this;
    }

    public String toFragmentString() {
        if (this.aliases.length() == 0) {
            return "";
        }
        return this.isNowaitEnabled ? this.dialect.getForUpdateNowaitString(this.aliases.toString()) : this.dialect.getForUpdateString(this.aliases.toString());
    }

    public ForUpdateFragment setNowaitEnabled(boolean bl) {
        this.isNowaitEnabled = bl;
        return this;
    }
}

