/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import org.hibernate.util.StringHelper;

public class Delete {
    private String tableName;
    private String[] primaryKeyColumnNames;
    private String versionColumnName;
    private String where;
    private String comment;

    public Delete setComment(String string) {
        this.comment = string;
        return this;
    }

    public Delete setTableName(String string) {
        this.tableName = string;
        return this;
    }

    public String toStatementString() {
        StringBuffer stringBuffer = new StringBuffer(this.tableName.length() + 10);
        if (this.comment != null) {
            stringBuffer.append("/* ").append(this.comment).append(" */ ");
        }
        stringBuffer.append("delete from ").append(this.tableName);
        if (this.where != null || this.primaryKeyColumnNames != null || this.versionColumnName != null) {
            stringBuffer.append(" where ");
        }
        boolean bl = false;
        if (this.primaryKeyColumnNames != null) {
            stringBuffer.append(StringHelper.join("=? and ", this.primaryKeyColumnNames)).append("=?");
            bl = true;
        }
        if (this.where != null) {
            if (bl) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(this.where);
            bl = true;
        }
        if (this.versionColumnName != null) {
            if (bl) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(this.versionColumnName).append("=?");
        }
        return stringBuffer.toString();
    }

    public Delete setWhere(String string) {
        this.where = string;
        return this;
    }

    public Delete addWhereFragment(String string) {
        this.where = this.where == null ? string : this.where + " and " + string;
        return this;
    }

    public Delete setPrimaryKeyColumnNames(String[] stringArray) {
        this.primaryKeyColumnNames = stringArray;
        return this;
    }

    public Delete setVersionColumnName(String string) {
        this.versionColumnName = string;
        return this;
    }
}

