/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.secure;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.hibernate.secure.JACCPermissions;

public class JACCPermissions {
    public static void checkPermission(Class clazz, String string, EJBMethodPermission eJBMethodPermission) throws SecurityException {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        try {
            Object object;
            JACCPermissions.setContextID(string);
            Policy policy = Policy.getPolicy();
            Subject subject = JACCPermissions.getContextSubject();
            Principal[] principalArray = null;
            if (subject != null) {
                object = subject.getPrincipals();
                principalArray = new Principal[object.size()];
                object.toArray(principalArray);
            }
            if (!policy.implies((ProtectionDomain)(object = new ProtectionDomain(codeSource, null, null, principalArray)), (Permission)eJBMethodPermission)) {
                String string2 = "Denied: " + eJBMethodPermission + ", caller=" + subject;
                SecurityException securityException = new SecurityException(string2);
                throw securityException;
            }
        }
        catch (PolicyContextException policyContextException) {
            throw new RuntimeException(policyContextException);
        }
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static String setContextID(String string) {
        SetContextID setContextID = new SetContextID(string);
        String string2 = (String)AccessController.doPrivileged(setContextID);
        return string2;
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction;
            {
                this.exAction = new PrivilegedExceptionAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public Object run() throws Exception {
                        return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
                    }
                };
            }

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof PolicyContextException) {
                        throw (PolicyContextException)((Object)exception);
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    private static class SetContextID
    implements PrivilegedAction {
        String contextID;

        SetContextID(String string) {
            this.contextID = string;
        }

        public Object run() {
            String string = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return string;
        }
    }
}

