/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.javassist;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.proxy.pojo.javassist.JavassistLazyInitializer;
import org.hibernate.type.AbstractComponentType;

public final class SerializableProxy
implements Serializable {
    private String entityName;
    private Class persistentClass;
    private Class[] interfaces;
    private Serializable id;
    private Class getIdentifierMethodClass;
    private Class setIdentifierMethodClass;
    private String getIdentifierMethodName;
    private String setIdentifierMethodName;
    private Class[] setIdentifierMethodParams;
    private AbstractComponentType componentIdType;

    public SerializableProxy() {
    }

    public SerializableProxy(String string, Class clazz, Class[] classArray, Serializable serializable, Method method, Method method2, AbstractComponentType abstractComponentType) {
        this.entityName = string;
        this.persistentClass = clazz;
        this.interfaces = classArray;
        this.id = serializable;
        if (method != null) {
            this.getIdentifierMethodClass = method.getDeclaringClass();
            this.getIdentifierMethodName = method.getName();
        }
        if (method2 != null) {
            this.setIdentifierMethodClass = method2.getDeclaringClass();
            this.setIdentifierMethodName = method2.getName();
            this.setIdentifierMethodParams = method2.getParameterTypes();
        }
        this.componentIdType = abstractComponentType;
    }

    private Object readResolve() {
        try {
            return JavassistLazyInitializer.getProxy(this.entityName, this.persistentClass, this.interfaces, this.getIdentifierMethodName == null ? null : this.getIdentifierMethodClass.getDeclaredMethod(this.getIdentifierMethodName, null), this.setIdentifierMethodName == null ? null : this.setIdentifierMethodClass.getDeclaredMethod(this.setIdentifierMethodName, this.setIdentifierMethodParams), this.componentIdType, this.id, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new HibernateException("could not create proxy for entity: " + this.entityName, noSuchMethodException);
        }
    }
}

