/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.cglib;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.cglib.SerializableProxy;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.ReflectHelper;

public final class CGLIBLazyInitializer
extends BasicLazyInitializer
implements InvocationHandler {
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getParameterTypes().length == 0 && method.getName().equals("finalize")) {
                return 1;
            }
            return 0;
        }
    };
    private Class[] interfaces;
    private boolean constructed = false;

    static HibernateProxy getProxy(String string, Class clazz, Class[] classArray, Method method, Method method2, AbstractComponentType abstractComponentType, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        try {
            CGLIBLazyInitializer cGLIBLazyInitializer = new CGLIBLazyInitializer(string, clazz, classArray, serializable, method, method2, abstractComponentType, sessionImplementor);
            Class clazz2 = CGLIBLazyInitializer.getProxyFactory(clazz, classArray);
            HibernateProxy hibernateProxy = CGLIBLazyInitializer.getProxyInstance(clazz2, cGLIBLazyInitializer);
            cGLIBLazyInitializer.constructed = true;
            return hibernateProxy;
        }
        catch (Throwable throwable) {
            LogFactory.getLog((Class)BasicLazyInitializer.class).error((Object)("CGLIB Enhancement failed: " + string), throwable);
            throw new HibernateException("CGLIB Enhancement failed: " + string, throwable);
        }
    }

    public static HibernateProxy getProxy(Class clazz, String string, Class clazz2, Class[] classArray, Method method, Method method2, AbstractComponentType abstractComponentType, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        HibernateProxy hibernateProxy;
        CGLIBLazyInitializer cGLIBLazyInitializer = new CGLIBLazyInitializer(string, clazz2, classArray, serializable, method, method2, abstractComponentType, sessionImplementor);
        try {
            hibernateProxy = CGLIBLazyInitializer.getProxyInstance(clazz, cGLIBLazyInitializer);
        }
        catch (Exception exception) {
            throw new HibernateException("CGLIB Enhancement failed: " + clazz2.getName(), exception);
        }
        cGLIBLazyInitializer.constructed = true;
        return hibernateProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HibernateProxy getProxyInstance(Class clazz, CGLIBLazyInitializer cGLIBLazyInitializer) throws InstantiationException, IllegalAccessException {
        HibernateProxy hibernateProxy;
        try {
            Enhancer.registerCallbacks((Class)clazz, (Callback[])new Callback[]{cGLIBLazyInitializer, null});
            hibernateProxy = (HibernateProxy)clazz.newInstance();
        }
        finally {
            Enhancer.registerCallbacks((Class)clazz, null);
        }
        return hibernateProxy;
    }

    public static Class getProxyFactory(Class clazz, Class[] classArray) throws HibernateException {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(classArray.length == 1 ? clazz : null);
        enhancer.setInterfaces(classArray);
        enhancer.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
        enhancer.setCallbackFilter(FINALIZE_FILTER);
        enhancer.setUseFactory(false);
        enhancer.setInterceptDuringConstruction(false);
        return enhancer.createClass();
    }

    private CGLIBLazyInitializer(String string, Class clazz, Class[] classArray, Serializable serializable, Method method, Method method2, AbstractComponentType abstractComponentType, SessionImplementor sessionImplementor) {
        super(string, clazz, serializable, method, method2, abstractComponentType, sessionImplementor);
        this.interfaces = classArray;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.constructed) {
            Object object2 = this.invoke(method, objectArray, object);
            if (object2 == INVOKE_IMPLEMENTATION) {
                Object object3 = this.getImplementation();
                try {
                    Object object4;
                    if (ReflectHelper.isPublic(this.persistentClass, method)) {
                        if (!method.getDeclaringClass().isInstance(object3)) {
                            throw new ClassCastException(object3.getClass().getName());
                        }
                        object4 = method.invoke(object3, objectArray);
                    } else {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        object4 = method.invoke(object3, objectArray);
                    }
                    return object4 == object3 ? object : object4;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            return object2;
        }
        if (method.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        throw new LazyInitializationException("unexpected case hit, method=" + method.getName());
    }

    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, this.interfaces, this.getIdentifier(), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }
}

