/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.AbstractLazyInitializer;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.MarkerObject;
import org.hibernate.util.ReflectHelper;

public abstract class BasicLazyInitializer
extends AbstractLazyInitializer {
    protected static final Object INVOKE_IMPLEMENTATION = new MarkerObject("INVOKE_IMPLEMENTATION");
    protected Class persistentClass;
    protected Method getIdentifierMethod;
    protected Method setIdentifierMethod;
    protected boolean overridesEquals;
    private Object replacement;
    protected AbstractComponentType componentIdType;

    protected BasicLazyInitializer(String string, Class clazz, Serializable serializable, Method method, Method method2, AbstractComponentType abstractComponentType, SessionImplementor sessionImplementor) {
        super(string, serializable, sessionImplementor);
        this.persistentClass = clazz;
        this.getIdentifierMethod = method;
        this.setIdentifierMethod = method2;
        this.componentIdType = abstractComponentType;
        this.overridesEquals = ReflectHelper.overridesEquals(clazz);
    }

    protected abstract Object serializableProxy();

    protected final Object invoke(Method method, Object[] objectArray, Object object) throws Throwable {
        String string = method.getName();
        int n = objectArray.length;
        if (n == 0) {
            if ("writeReplace".equals(string)) {
                return this.getReplacement();
            }
            if (!this.overridesEquals && "hashCode".equals(string)) {
                return new Integer(System.identityHashCode(object));
            }
            if (this.isUninitialized() && method.equals(this.getIdentifierMethod)) {
                return this.getIdentifier();
            }
            if ("getHibernateLazyInitializer".equals(string)) {
                return this;
            }
        } else if (n == 1) {
            if (!this.overridesEquals && "equals".equals(string)) {
                return objectArray[0] == object ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.equals(this.setIdentifierMethod)) {
                this.initialize();
                this.setIdentifier((Serializable)objectArray[0]);
                return INVOKE_IMPLEMENTATION;
            }
        }
        if (this.componentIdType != null && this.componentIdType.isMethodOf(method)) {
            return method.invoke((Object)this.getIdentifier(), objectArray);
        }
        return INVOKE_IMPLEMENTATION;
    }

    private Object getReplacement() {
        SessionImplementor sessionImplementor = this.getSession();
        if (this.isUninitialized() && sessionImplementor != null && sessionImplementor.isOpen()) {
            EntityKey entityKey = new EntityKey(this.getIdentifier(), sessionImplementor.getFactory().getEntityPersister(this.getEntityName()), sessionImplementor.getEntityMode());
            Object object = sessionImplementor.getPersistenceContext().getEntity(entityKey);
            if (object != null) {
                this.setImplementation(object);
            }
        }
        if (this.isUninitialized()) {
            if (this.replacement == null) {
                this.replacement = this.serializableProxy();
            }
            return this.replacement;
        }
        return this.getTarget();
    }

    public final Class getPersistentClass() {
        return this.persistentClass;
    }
}

