/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;

public class DirectPropertyAccessor
implements PropertyAccessor {
    private static Field getField(Class clazz, String string) throws PropertyNotFoundException {
        Field field;
        if (clazz == null || clazz == Object.class) {
            throw new PropertyNotFoundException("field not found: " + string);
        }
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = DirectPropertyAccessor.getField(clazz, clazz.getSuperclass(), string);
        }
        if (!ReflectHelper.isPublic(clazz, field)) {
            field.setAccessible(true);
        }
        return field;
    }

    private static Field getField(Class clazz, Class clazz2, String string) throws PropertyNotFoundException {
        Field field;
        if (clazz2 == null || clazz2 == Object.class) {
            throw new PropertyNotFoundException("field [" + string + "] not found on " + clazz.getName());
        }
        try {
            field = clazz2.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = DirectPropertyAccessor.getField(clazz, clazz2.getSuperclass(), string);
        }
        if (!ReflectHelper.isPublic(clazz2, field)) {
            field.setAccessible(true);
        }
        return field;
    }

    public Getter getGetter(Class clazz, String string) throws PropertyNotFoundException {
        return new DirectGetter(DirectPropertyAccessor.getField(clazz, string), clazz, string);
    }

    public Setter getSetter(Class clazz, String string) throws PropertyNotFoundException {
        return new DirectSetter(DirectPropertyAccessor.getField(clazz, string), clazz, string);
    }

    public static final class DirectGetter
    implements Getter {
        private final transient Field field;
        private final Class clazz;
        private final String name;

        DirectGetter(Field field, Class clazz, String string) {
            this.field = field;
            this.clazz = clazz;
            this.name = string;
        }

        public Object get(Object object) throws HibernateException {
            try {
                return this.field.get(object);
            }
            catch (Exception exception) {
                throw new PropertyAccessException(exception, "could not get a field value by reflection", false, this.clazz, this.name);
            }
        }

        public Object getForInsert(Object object, Map map, SessionImplementor sessionImplementor) {
            return this.get(object);
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class getReturnType() {
            return this.field.getType();
        }

        Object readResolve() {
            return new DirectGetter(DirectPropertyAccessor.getField(this.clazz, this.name), this.clazz, this.name);
        }

        public String toString() {
            return "DirectGetter(" + this.clazz.getName() + '.' + this.name + ')';
        }
    }

    public static final class DirectSetter
    implements Setter {
        private final transient Field field;
        private final Class clazz;
        private final String name;

        DirectSetter(Field field, Class clazz, String string) {
            this.field = field;
            this.clazz = clazz;
            this.name = string;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object object, Object object2, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
            try {
                this.field.set(object, object2);
            }
            catch (Exception exception) {
                throw new PropertyAccessException(exception, "could not set a field value by reflection", true, this.clazz, this.name);
            }
        }

        public String toString() {
            return "DirectSetter(" + this.clazz.getName() + '.' + this.name + ')';
        }

        Object readResolve() {
            return new DirectSetter(DirectPropertyAccessor.getField(this.clazz, this.name), this.clazz, this.name);
        }
    }
}

