/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.util.StringTokenizer;

public class DDLFormatter {
    private String sql;

    public DDLFormatter(String string) {
        this.sql = string;
    }

    public String format() {
        if (this.sql.toLowerCase().startsWith("create table")) {
            return this.formatCreateTable();
        }
        if (this.sql.toLowerCase().startsWith("alter table")) {
            return this.formatAlterTable();
        }
        if (this.sql.toLowerCase().startsWith("comment on")) {
            return this.formatCommentOn();
        }
        return "\n    " + this.sql;
    }

    private String formatCommentOn() {
        StringBuffer stringBuffer = new StringBuffer(60).append("\n    ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.sql, " '[]\"", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            stringBuffer.append(string);
            if (DDLFormatter.isQuote(string)) {
                bl = !bl;
                continue;
            }
            if (bl || !"is".equals(string)) continue;
            stringBuffer.append("\n       ");
        }
        return stringBuffer.toString();
    }

    private String formatAlterTable() {
        StringBuffer stringBuffer = new StringBuffer(60).append("\n    ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.sql, " (,)'[]\"", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (DDLFormatter.isQuote(string)) {
                bl = !bl;
            } else if (!bl && DDLFormatter.isBreak(string)) {
                stringBuffer.append("\n        ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String formatCreateTable() {
        StringBuffer stringBuffer = new StringBuffer(60).append("\n    ");
        StringTokenizer stringTokenizer = new StringTokenizer(this.sql, "(,)'[]\"", true);
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (DDLFormatter.isQuote(string)) {
                bl = !bl;
                stringBuffer.append(string);
                continue;
            }
            if (bl) {
                stringBuffer.append(string);
                continue;
            }
            if (")".equals(string) && --n == 0) {
                stringBuffer.append("\n    ");
            }
            stringBuffer.append(string);
            if (",".equals(string) && n == 1) {
                stringBuffer.append("\n       ");
            }
            if (!"(".equals(string) || ++n != 1) continue;
            stringBuffer.append("\n        ");
        }
        return stringBuffer.toString();
    }

    private static boolean isBreak(String string) {
        return "drop".equals(string) || "add".equals(string) || "references".equals(string) || "foreign".equals(string) || "on".equals(string);
    }

    private static boolean isQuote(String string) {
        return "\"".equals(string) || "`".equals(string) || "]".equals(string) || "[".equals(string) || "'".equals(string);
    }
}

