/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.SelectFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class JoinedSubclassEntityPersister
extends AbstractEntityPersister {
    private final int tableSpan;
    private final String[] tableNames;
    private final String[] naturalOrderTableNames;
    private final String[][] tableKeyColumns;
    private final String[][] naturalOrderTableKeyColumns;
    private final boolean[] naturalOrderCascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] naturalOrderPropertyTableNumbers;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final Map subclassesByDiscriminatorValue = new HashMap();
    private final String[] discriminatorValues;
    private final String[] notNullColumnNames;
    private final int[] notNullColumnTableNumbers;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final String discriminatorSQLString;

    public JoinedSubclassEntityPersister(PersistentClass persistentClass, CacheConcurrencyStrategy cacheConcurrencyStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(persistentClass, cacheConcurrencyStrategy, sessionFactoryImplementor);
        Integer n;
        Object object;
        Object object2;
        Serializable serializable;
        String[] stringArray;
        Object object3;
        Object object4;
        Serializable serializable2;
        Serializable serializable3;
        Integer n2;
        if (persistentClass.isPolymorphic()) {
            try {
                n2 = new Integer(persistentClass.getSubclassId());
                this.discriminatorSQLString = ((Object)n2).toString();
            }
            catch (Exception exception) {
                throw new MappingException("Could not format discriminator value to SQL string", exception);
            }
        } else {
            n2 = null;
            this.discriminatorSQLString = null;
        }
        if (this.optimisticLockMode() > 0) {
            throw new MappingException("optimistic-lock=all|dirty not supported for joined-subclass mappings [" + this.getEntityName() + "]");
        }
        int n3 = this.getIdentifierColumnSpan();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
        Iterator iterator = persistentClass.getTableClosureIterator();
        Iterator iterator2 = persistentClass.getKeyClosureIterator();
        while (iterator.hasNext()) {
            serializable3 = (Table)iterator.next();
            serializable2 = (KeyValue)iterator2.next();
            object4 = ((Table)serializable3).getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList.add((String)object4);
            object3 = new String[n3];
            stringArray = serializable2.getColumnIterator();
            for (int i = 0; i < n3; ++i) {
                object3[i] = ((Column)stringArray.next()).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            arrayList2.add((String[])object3);
            arrayList3.add(new Boolean(serializable2.isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete()));
        }
        this.naturalOrderTableNames = ArrayHelper.toStringArray(arrayList);
        this.naturalOrderTableKeyColumns = ArrayHelper.to2DStringArray(arrayList2);
        this.naturalOrderCascadeDeleteEnabled = ArrayHelper.toBooleanArray(arrayList3);
        serializable3 = new ArrayList();
        serializable2 = new ArrayList();
        arrayList2 = new ArrayList();
        iterator = persistentClass.getSubclassTableClosureIterator();
        while (iterator.hasNext()) {
            object4 = (Table)iterator.next();
            ((ArrayList)serializable2).add(new Boolean(persistentClass.isClassOrSuperclassTable((Table)object4)));
            object3 = ((Table)object4).getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            ((ArrayList)serializable3).add(object3);
            stringArray = new String[n3];
            Iterator iterator3 = ((Table)object4).getPrimaryKey().getColumnIterator();
            for (int i = 0; i < n3; ++i) {
                stringArray[i] = ((Column)iterator3.next()).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            arrayList2.add(stringArray);
        }
        this.subclassTableNameClosure = ArrayHelper.toStringArray((Collection)((Object)serializable3));
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(arrayList2);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray((Collection)((Object)serializable2));
        this.constraintOrderedTableNames = new String[this.subclassTableNameClosure.length];
        this.constraintOrderedKeyColumnNames = new String[this.subclassTableNameClosure.length][];
        int n4 = 0;
        int n5 = this.subclassTableNameClosure.length - 1;
        while (n5 >= 0) {
            this.constraintOrderedTableNames[n4] = this.subclassTableNameClosure[n5];
            this.constraintOrderedKeyColumnNames[n4] = this.subclassTableKeyColumnClosure[n5];
            --n5;
            ++n4;
        }
        this.tableSpan = this.naturalOrderTableNames.length;
        this.tableNames = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableNames);
        this.tableKeyColumns = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumns);
        JoinedSubclassEntityPersister.reverse(this.subclassTableNameClosure, this.tableSpan);
        JoinedSubclassEntityPersister.reverse((Object[])this.subclassTableKeyColumnClosure, this.tableSpan);
        this.spaces = ArrayHelper.join(this.tableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        this.customSQLInsert = new String[this.tableSpan];
        this.customSQLUpdate = new String[this.tableSpan];
        this.customSQLDelete = new String[this.tableSpan];
        this.insertCallable = new boolean[this.tableSpan];
        this.updateCallable = new boolean[this.tableSpan];
        this.deleteCallable = new boolean[this.tableSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        int n6 = this.tableSpan - 1;
        for (PersistentClass persistentClass2 = persistentClass; persistentClass2 != null; persistentClass2 = persistentClass2.getSuperclass()) {
            this.customSQLInsert[n6] = persistentClass2.getCustomSQLInsert();
            this.insertCallable[n6] = this.customSQLInsert[n6] != null && persistentClass2.isCustomInsertCallable();
            this.insertResultCheckStyles[n6] = persistentClass2.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[n6], this.insertCallable[n6]) : persistentClass2.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[n6] = persistentClass2.getCustomSQLUpdate();
            this.updateCallable[n6] = this.customSQLUpdate[n6] != null && persistentClass2.isCustomUpdateCallable();
            this.updateResultCheckStyles[n6] = persistentClass2.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[n6], this.updateCallable[n6]) : persistentClass2.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[n6] = persistentClass2.getCustomSQLDelete();
            this.deleteCallable[n6] = this.customSQLDelete[n6] != null && persistentClass2.isCustomDeleteCallable();
            this.deleteResultCheckStyles[n6] = persistentClass2.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[n6], this.deleteCallable[n6]) : persistentClass2.getCustomSQLDeleteCheckStyle();
            --n6;
        }
        if (n6 != -1) {
            throw new AssertionFailure("Tablespan does not match height of joined-subclass hiearchy.");
        }
        int n7 = this.getPropertySpan();
        this.naturalOrderPropertyTableNumbers = new int[n7];
        this.propertyTableNumbers = new int[n7];
        Iterator iterator4 = persistentClass.getPropertyClosureIterator();
        int n8 = 0;
        while (iterator4.hasNext()) {
            serializable = (Property)iterator4.next();
            object2 = ((Property)serializable).getValue().getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            this.propertyTableNumbers[n8] = JoinedSubclassEntityPersister.getTableId((String)object2, this.tableNames);
            this.naturalOrderPropertyTableNumbers[n8] = JoinedSubclassEntityPersister.getTableId((String)object2, this.naturalOrderTableNames);
            ++n8;
        }
        serializable = new ArrayList();
        object2 = new ArrayList();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        iterator4 = persistentClass.getSubclassPropertyClosureIterator();
        while (iterator4.hasNext()) {
            Property property = (Property)iterator4.next();
            Table table = property.getValue().getTable();
            object = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            n = new Integer(JoinedSubclassEntityPersister.getTableId((String)object, this.subclassTableNameClosure));
            arrayList4.add(n);
            Iterator iterator5 = property.getColumnIterator();
            while (iterator5.hasNext()) {
                Selectable selectable = (Selectable)iterator5.next();
                if (selectable.isFormula()) {
                    ((ArrayList)object2).add(n);
                    continue;
                }
                ((ArrayList)serializable).add(n);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray((Collection)((Object)serializable));
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(arrayList4);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray((Collection)object2);
        int n9 = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[n9];
        this.subclassClosure[n9 - 1] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            int n10;
            this.subclassesByDiscriminatorValue.put(n2, this.getEntityName());
            this.discriminatorValues = new String[n9];
            this.discriminatorValues[n9 - 1] = this.discriminatorSQLString;
            this.notNullColumnTableNumbers = new int[n9];
            this.notNullColumnTableNumbers[n9 - 1] = n10 = JoinedSubclassEntityPersister.getTableId(persistentClass.getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
            this.notNullColumnNames = new String[n9];
            this.notNullColumnNames[n9 - 1] = this.subclassTableKeyColumnClosure[n10][0];
        } else {
            this.discriminatorValues = null;
            this.notNullColumnTableNumbers = null;
            this.notNullColumnNames = null;
        }
        iterator4 = persistentClass.getSubclassIterator();
        int n11 = 0;
        while (iterator4.hasNext()) {
            object = (Subclass)iterator4.next();
            this.subclassClosure[n11] = ((PersistentClass)object).getEntityName();
            try {
                if (persistentClass.isPolymorphic()) {
                    int n12;
                    n = new Integer(((Subclass)object).getSubclassId());
                    this.subclassesByDiscriminatorValue.put(n, ((PersistentClass)object).getEntityName());
                    this.discriminatorValues[n11] = n.toString();
                    this.notNullColumnTableNumbers[n11] = n12 = JoinedSubclassEntityPersister.getTableId(((Subclass)object).getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
                    this.notNullColumnNames[n11] = this.subclassTableKeyColumnClosure[n12][0];
                }
            }
            catch (Exception exception) {
                throw new MappingException("Error parsing discriminator value", exception);
            }
            ++n11;
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    public String getSubclassPropertyTableName(int n) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[n]];
    }

    public Type getDiscriminatorType() {
        return Hibernate.INTEGER;
    }

    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLString;
    }

    public String getSubclassForDiscriminatorValue(Object object) {
        return (String)this.subclassesByDiscriminatorValue.get(object);
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected String getTableName(int n) {
        return this.naturalOrderTableNames[n];
    }

    protected String[] getKeyColumns(int n) {
        return this.naturalOrderTableKeyColumns[n];
    }

    protected boolean isTableCascadeDeleteEnabled(int n) {
        return this.naturalOrderCascadeDeleteEnabled[n];
    }

    protected boolean isPropertyOfTable(int n, int n2) {
        return this.naturalOrderPropertyTableNumbers[n] == n2;
    }

    private static final void reverse(Object[] objectArray, int n) {
        int n2;
        Object[] objectArray2 = new Object[n];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n - n2 - 1];
        }
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = objectArray2[n2];
        }
    }

    private static final String[] reverse(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[n - i - 1];
        }
        return stringArray2;
    }

    private static final String[][] reverse(String[][] stringArray) {
        int n = stringArray.length;
        String[][] stringArray2 = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[n - i - 1];
        }
        return stringArray2;
    }

    public String fromTableFragment(String string) {
        return this.getTableName() + ' ' + string;
    }

    public String getTableName() {
        return this.tableNames[0];
    }

    private static int getTableId(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        throw new AssertionFailure("Table " + string + " not found");
    }

    public void addDiscriminatorToSelect(SelectFragment selectFragment, String string, String string2) {
        if (this.hasSubclasses()) {
            selectFragment.setExtraSelectList(this.discriminatorFragment(string), this.getDiscriminatorAlias());
        }
    }

    private CaseFragment discriminatorFragment(String string) {
        CaseFragment caseFragment = this.getFactory().getDialect().createCaseFragment();
        for (int i = 0; i < this.discriminatorValues.length; ++i) {
            caseFragment.addWhenColumnNotNull(this.generateTableAlias(string, this.notNullColumnTableNumbers[i]), this.notNullColumnNames[i], this.discriminatorValues[i]);
        }
        return caseFragment;
    }

    public String filterFragment(String string) {
        return this.hasWhere() ? " and " + this.getSQLWhereString(this.generateFilterConditionAlias(string)) : "";
    }

    public String generateFilterConditionAlias(String string) {
        return this.generateTableAlias(string, this.tableSpan - 1);
    }

    public String[] getIdentifierColumnNames() {
        return this.tableKeyColumns[0];
    }

    public String[] toColumns(String string, String string2) throws QueryException {
        if ("class".equals(string2)) {
            return new String[]{this.discriminatorFragment(string).toFragmentString()};
        }
        return super.toColumns(string, string2);
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    protected int getSubclassPropertyTableNumber(int n) {
        return this.subclassPropertyTableNumberClosure[n];
    }

    public int getTableSpan() {
        return this.tableSpan;
    }

    public boolean isMultiTable() {
        return true;
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    protected int[] getPropertyTableNumbers() {
        return this.naturalOrderPropertyTableNumbers;
    }

    protected String[] getSubclassTableKeyColumns(int n) {
        return this.subclassTableKeyColumnClosure[n];
    }

    public String getSubclassTableName(int n) {
        return this.subclassTableNameClosure[n];
    }

    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    protected boolean isClassOrSuperclassTable(int n) {
        return this.isClassOrSuperclassTable[n];
    }

    public String getPropertyTableName(String string) {
        Integer n = this.getEntityMetamodel().getPropertyIndexOrNull(string);
        if (n == null) {
            return null;
        }
        return this.tableNames[this.propertyTableNumbers[n]];
    }

    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    public String getRootTableName() {
        return this.naturalOrderTableNames[0];
    }

    public String getRootTableAlias(String string) {
        return this.generateTableAlias(string, JoinedSubclassEntityPersister.getTableId(this.getRootTableName(), this.tableNames));
    }

    public Queryable.Declarer getSubclassPropertyDeclarer(String string) {
        if ("class".equals(string)) {
            return Queryable.Declarer.SUBCLASS;
        }
        return super.getSubclassPropertyDeclarer(string);
    }
}

