/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubselectOneToManyLoader;
import org.hibernate.loader.entity.CollectionElementLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;
import org.hibernate.util.ArrayHelper;

public class OneToManyPersister
extends AbstractCollectionPersister {
    private final boolean cascadeDeleteEnabled;
    private final boolean keyIsNullable;
    private final boolean keyIsUpdateable;

    protected boolean isRowDeleteEnabled() {
        return this.keyIsUpdateable && this.keyIsNullable;
    }

    protected boolean isRowInsertEnabled() {
        return this.keyIsUpdateable;
    }

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public OneToManyPersister(Collection collection, CacheConcurrencyStrategy cacheConcurrencyStrategy, Configuration configuration, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException, CacheException {
        super(collection, cacheConcurrencyStrategy, configuration, sessionFactoryImplementor);
        this.cascadeDeleteEnabled = collection.getKey().isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete();
        this.keyIsNullable = collection.getKey().isNullable();
        this.keyIsUpdateable = collection.getKey().isUpdateable();
    }

    protected String generateDeleteString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null").setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.hasWhere) {
            update.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many " + this.getRole());
        }
        return update.toStatementString();
    }

    protected String generateInsertRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("create one-to-many row " + this.getRole());
        }
        return update.setPrimaryKeyColumnNames(this.elementColumnNames).toStatementString();
    }

    protected String generateUpdateRowString() {
        return null;
    }

    protected String generateDeleteRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null");
        if (this.hasIndex && !this.indexContainsFormula) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("delete one-to-many row " + this.getRole());
        }
        String[] stringArray = ArrayHelper.join(this.keyColumnNames, this.elementColumnNames);
        return update.setPrimaryKeyColumnNames(stringArray).toStatementString();
    }

    public boolean consumesEntityAlias() {
        return true;
    }

    public boolean consumesCollectionAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return true;
    }

    public boolean isManyToMany() {
        return false;
    }

    protected int doUpdateRows(Serializable serializable, PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        try {
            Object object;
            Object object2;
            int n;
            int n2 = 0;
            if (this.isRowDeleteEnabled()) {
                boolean bl = true;
                PreparedStatement preparedStatement = null;
                try {
                    n = 0;
                    object2 = persistentCollection.entries(this);
                    int n3 = 1;
                    Expectation expectation = Expectations.NONE;
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (persistentCollection.needsUpdating(object, n, this.elementType)) {
                            if (preparedStatement == null) {
                                String string = this.getSQLDeleteRowString();
                                if (this.isDeleteCallable()) {
                                    expectation = Expectations.appropriateExpectation(this.getDeleteCheckStyle());
                                    bl = expectation.canBeBatched();
                                    preparedStatement = bl ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareCallableStatement(string);
                                    n3 += expectation.prepare(preparedStatement);
                                } else {
                                    preparedStatement = sessionImplementor.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                                }
                            }
                            int n4 = this.writeKey(preparedStatement, serializable, n3, sessionImplementor);
                            this.writeElementToWhere(preparedStatement, persistentCollection.getSnapshotElement(object, n), n4, sessionImplementor);
                            if (bl) {
                                sessionImplementor.getBatcher().addToBatch(expectation);
                            } else {
                                expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
                catch (SQLException sQLException) {
                    if (bl) {
                        sessionImplementor.getBatcher().abortBatch(sQLException);
                    }
                    throw sQLException;
                }
                finally {
                    if (!bl) {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                }
            }
            if (this.isRowInsertEnabled()) {
                Expectation expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
                boolean bl = this.isInsertCallable();
                n = expectation.canBeBatched();
                object2 = this.getSQLInsertRowString();
                PreparedStatement preparedStatement = null;
                try {
                    int n5 = 0;
                    object = persistentCollection.entries(this);
                    while (object.hasNext()) {
                        Object e = object.next();
                        int n6 = 1;
                        if (persistentCollection.needsUpdating(e, n5, this.elementType)) {
                            if (n != 0) {
                                if (preparedStatement == null) {
                                    preparedStatement = bl ? sessionImplementor.getBatcher().prepareBatchCallableStatement((String)object2) : sessionImplementor.getBatcher().prepareBatchStatement((String)object2);
                                }
                            } else {
                                preparedStatement = bl ? sessionImplementor.getBatcher().prepareCallableStatement((String)object2) : sessionImplementor.getBatcher().prepareStatement((String)object2);
                            }
                            int n7 = this.writeKey(preparedStatement, serializable, n6 += expectation.prepare(preparedStatement), sessionImplementor);
                            if (this.hasIndex && !this.indexContainsFormula) {
                                n7 = this.writeIndexToWhere(preparedStatement, persistentCollection.getIndex(e, n5, this), n7, sessionImplementor);
                            }
                            this.writeElementToWhere(preparedStatement, persistentCollection.getElement(e), n7, sessionImplementor);
                            if (n != 0) {
                                sessionImplementor.getBatcher().addToBatch(expectation);
                            } else {
                                expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                            }
                            ++n2;
                        }
                        ++n5;
                    }
                }
                catch (SQLException sQLException) {
                    if (n != 0) {
                        sessionImplementor.getBatcher().abortBatch(sQLException);
                    }
                    throw sQLException;
                }
                finally {
                    if (n == 0) {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                }
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getSQLExceptionConverter(), sQLException, "could not update collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.getSQLInsertRowString());
        }
    }

    public String selectFragment(Joinable joinable, String string, String string2, String string3, String string4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(this.selectFragment(string2, string4)).append(", ");
        }
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)this.getElementPersister();
        return stringBuffer.append(outerJoinLoadable.selectFragment(string2, string3)).toString();
    }

    protected CollectionInitializer createCollectionInitializer(Map map) throws MappingException {
        return BatchingCollectionInitializer.createBatchingOneToManyInitializer(this, this.batchSize, this.getFactory(), map);
    }

    public String fromJoinFragment(String string, boolean bl, boolean bl2) {
        return ((Joinable)((Object)this.getElementPersister())).fromJoinFragment(string, bl, bl2);
    }

    public String whereJoinFragment(String string, boolean bl, boolean bl2) {
        return ((Joinable)((Object)this.getElementPersister())).whereJoinFragment(string, bl, bl2);
    }

    public String getTableName() {
        return ((Joinable)((Object)this.getElementPersister())).getTableName();
    }

    public String filterFragment(String string) throws MappingException {
        String string2 = super.filterFragment(string);
        if (this.getElementPersister() instanceof Joinable) {
            string2 = string2 + ((Joinable)((Object)this.getElementPersister())).oneToManyFilterFragment(string);
        }
        return string2;
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselectFetch, SessionImplementor sessionImplementor) {
        return new SubselectOneToManyLoader(this, subselectFetch.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselectFetch.getResult(), subselectFetch.getQueryParameters(), subselectFetch.getNamedParameterLocMap(), sessionImplementor.getFactory(), sessionImplementor.getEnabledFilters());
    }

    public Object getElementByIndex(Serializable serializable, Object object, SessionImplementor sessionImplementor, Object object2) {
        return new CollectionElementLoader(this, this.getFactory(), sessionImplementor.getEnabledFilters()).loadElement(sessionImplementor, serializable, this.incrementIndexByBase(object));
    }
}

