/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.CollectionPersister;

public final class NamedQueryCollectionInitializer
implements CollectionInitializer {
    private final String queryName;
    private final CollectionPersister persister;
    private static final Log log = LogFactory.getLog((Class)NamedQueryCollectionInitializer.class);

    public NamedQueryCollectionInitializer(String string, CollectionPersister collectionPersister) {
        this.queryName = string;
        this.persister = collectionPersister;
    }

    public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        AbstractQueryImpl abstractQueryImpl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("initializing collection: " + this.persister.getRole() + " using named query: " + this.queryName));
        }
        if ((abstractQueryImpl = (AbstractQueryImpl)sessionImplementor.getNamedSQLQuery(this.queryName)).getNamedParameters().length > 0) {
            abstractQueryImpl.setParameter(abstractQueryImpl.getNamedParameters()[0], (Object)serializable, this.persister.getKeyType());
        } else {
            abstractQueryImpl.setParameter(0, (Object)serializable, this.persister.getKeyType());
        }
        abstractQueryImpl.setCollectionKey(serializable).setFlushMode(FlushMode.MANUAL).list();
    }
}

