/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubselectCollectionLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.Update;
import org.hibernate.type.AssociationType;
import org.hibernate.util.ArrayHelper;

public class BasicCollectionPersister
extends AbstractCollectionPersister {
    public boolean isCascadeDeleteEnabled() {
        return false;
    }

    public BasicCollectionPersister(Collection collection, CacheConcurrencyStrategy cacheConcurrencyStrategy, Configuration configuration, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException, CacheException {
        super(collection, cacheConcurrencyStrategy, configuration, sessionFactoryImplementor);
    }

    protected String generateDeleteString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName).setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasWhere) {
            delete.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection " + this.getRole());
        }
        return delete.toStatementString();
    }

    protected String generateInsertRowString() {
        Insert insert = new Insert(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIdentifier) {
            insert.addColumn(this.identifierColumnName);
        }
        if (this.hasIndex) {
            insert.addColumns(this.indexColumnNames, this.indexColumnIsSettable);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert collection row " + this.getRole());
        }
        insert.addColumns(this.elementColumnNames, this.elementColumnIsSettable);
        return insert.toStatementString();
    }

    protected String generateUpdateRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName);
        update.addColumns(this.elementColumnNames, this.elementColumnIsSettable);
        if (this.hasIdentifier) {
            update.setPrimaryKeyColumnNames(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexContainsFormula) {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.elementColumnNames, this.elementColumnIsInPrimaryKey));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("update collection row " + this.getRole());
        }
        return update.toStatementString();
    }

    protected String generateDeleteRowString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName);
        if (this.hasIdentifier) {
            delete.setPrimaryKeyColumnNames(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexContainsFormula) {
            delete.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            delete.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.elementColumnNames, this.elementColumnIsInPrimaryKey));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection row " + this.getRole());
        }
        return delete.toStatementString();
    }

    public boolean consumesEntityAlias() {
        return false;
    }

    public boolean consumesCollectionAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isManyToMany() {
        return this.elementType.isEntityType();
    }

    protected int doUpdateRows(Serializable serializable, PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        if (ArrayHelper.isAllFalse(this.elementColumnIsSettable)) {
            return 0;
        }
        try {
            PreparedStatement preparedStatement = null;
            Expectation expectation = Expectations.appropriateExpectation(this.getUpdateCheckStyle());
            boolean bl = this.isUpdateCallable();
            boolean bl2 = expectation.canBeBatched();
            Iterator iterator = persistentCollection.entries(this);
            String string = this.getSQLUpdateRowString();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (persistentCollection.needsUpdating(e, n, this.elementType)) {
                    int n3 = 1;
                    if (bl2) {
                        if (preparedStatement == null) {
                            preparedStatement = bl ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string);
                        }
                    } else {
                        preparedStatement = bl ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string);
                    }
                    try {
                        int n4 = this.writeElement(preparedStatement, persistentCollection.getElement(e), n3 += expectation.prepare(preparedStatement), sessionImplementor);
                        if (this.hasIdentifier) {
                            this.writeIdentifier(preparedStatement, persistentCollection.getIdentifier(e, n), n4, sessionImplementor);
                        } else {
                            n4 = this.writeKey(preparedStatement, serializable, n4, sessionImplementor);
                            if (this.hasIndex && !this.indexContainsFormula) {
                                this.writeIndexToWhere(preparedStatement, persistentCollection.getIndex(e, n, this), n4, sessionImplementor);
                            } else {
                                this.writeElementToWhere(preparedStatement, persistentCollection.getSnapshotElement(e, n), n4, sessionImplementor);
                            }
                        }
                        if (bl2) {
                            sessionImplementor.getBatcher().addToBatch(expectation);
                        } else {
                            expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (bl2) {
                            sessionImplementor.getBatcher().abortBatch(sQLException);
                        }
                        throw sQLException;
                    }
                    finally {
                        if (!bl2) {
                            sessionImplementor.getBatcher().closeStatement(preparedStatement);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getSQLExceptionConverter(), sQLException, "could not update collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.getSQLUpdateRowString());
        }
    }

    public String selectFragment(Joinable joinable, String string, String string2, String string3, String string4, boolean bl) {
        AssociationType associationType;
        if (joinable != null && this.isManyToMany() && !joinable.isCollection() && joinable.equals((associationType = (AssociationType)this.getElementType()).getAssociatedJoinable(this.getFactory()))) {
            return this.manyToManySelectFragment(joinable, string, string2, string4);
        }
        return bl ? this.selectFragment(string2, string4) : "";
    }

    private String manyToManySelectFragment(Joinable joinable, String string, String string2, String string3) {
        SelectFragment selectFragment = this.generateSelectFragment(string2, string3);
        String[] stringArray = joinable.getKeyColumnNames();
        selectFragment.addColumns(string, stringArray, this.elementColumnAliases);
        this.appendIndexColumns(selectFragment, string2);
        this.appendIdentifierColumns(selectFragment, string2);
        return selectFragment.toFragmentString().substring(2);
    }

    protected CollectionInitializer createCollectionInitializer(Map map) throws MappingException {
        return BatchingCollectionInitializer.createBatchingCollectionInitializer(this, this.batchSize, this.getFactory(), map);
    }

    public String fromJoinFragment(String string, boolean bl, boolean bl2) {
        return "";
    }

    public String whereJoinFragment(String string, boolean bl, boolean bl2) {
        return "";
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselectFetch, SessionImplementor sessionImplementor) {
        return new SubselectCollectionLoader(this, subselectFetch.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselectFetch.getResult(), subselectFetch.getQueryParameters(), subselectFetch.getNamedParameterLocMap(), sessionImplementor.getFactory(), sessionImplementor.getEnabledFilters());
    }
}

