/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.TransientObjectException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.entry.CacheEntryStructure;
import org.hibernate.cache.entry.StructuredCollectionCacheEntry;
import org.hibernate.cache.entry.StructuredMapCacheEntry;
import org.hibernate.cache.entry.UnstructuredCacheEntry;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.CompositeElementPropertyMapping;
import org.hibernate.persister.collection.ElementPropertyMapping;
import org.hibernate.persister.collection.NamedQueryCollectionInitializer;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Alias;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.FilterHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractCollectionPersister
implements CollectionMetadata,
SQLLoadableCollection {
    private final String role;
    private final String sqlDeleteString;
    private final String sqlInsertRowString;
    private final String sqlUpdateRowString;
    private final String sqlDeleteRowString;
    private final String sqlSelectSizeString;
    private final String sqlSelectRowByIndexString;
    private final String sqlDetectRowByIndexString;
    private final String sqlDetectRowByElementString;
    private final String sqlOrderByString;
    protected final String sqlWhereString;
    private final String sqlOrderByStringTemplate;
    private final String sqlWhereStringTemplate;
    private final boolean hasOrder;
    protected final boolean hasWhere;
    private final int baseIndex;
    private final String nodeName;
    private final String elementNodeName;
    private final String indexNodeName;
    protected final boolean indexContainsFormula;
    protected final boolean elementIsPureFormula;
    private final Type keyType;
    private final Type indexType;
    protected final Type elementType;
    private final Type identifierType;
    protected final String[] keyColumnNames;
    protected final String[] indexColumnNames;
    protected final String[] indexFormulaTemplates;
    protected final String[] indexFormulas;
    protected final boolean[] indexColumnIsSettable;
    protected final String[] elementColumnNames;
    protected final String[] elementFormulaTemplates;
    protected final String[] elementFormulas;
    protected final boolean[] elementColumnIsSettable;
    protected final boolean[] elementColumnIsInPrimaryKey;
    protected final String[] indexColumnAliases;
    protected final String[] elementColumnAliases;
    protected final String[] keyColumnAliases;
    protected final String identifierColumnName;
    private final String identifierColumnAlias;
    protected final String qualifiedTableName;
    private final String queryLoaderName;
    private final boolean isPrimitiveArray;
    private final boolean isArray;
    protected final boolean hasIndex;
    protected final boolean hasIdentifier;
    private final boolean isLazy;
    private final boolean isExtraLazy;
    private final boolean isInverse;
    private final boolean isMutable;
    private final boolean isVersioned;
    protected final int batchSize;
    private final FetchMode fetchMode;
    private final boolean hasOrphanDelete;
    private final boolean subselectLoadable;
    private final Class elementClass;
    private final String entityName;
    private final Dialect dialect;
    private final SQLExceptionConverter sqlExceptionConverter;
    private final SessionFactoryImplementor factory;
    private final EntityPersister ownerPersister;
    private final IdentifierGenerator identifierGenerator;
    private final PropertyMapping elementPropertyMapping;
    private final EntityPersister elementPersister;
    private final CacheConcurrencyStrategy cache;
    private final CollectionType collectionType;
    private CollectionInitializer initializer;
    private final CacheEntryStructure cacheEntryStructure;
    private final FilterHelper filterHelper;
    private final FilterHelper manyToManyFilterHelper;
    private final String manyToManyWhereString;
    private final String manyToManyWhereTemplate;
    private final String manyToManyOrderByString;
    private final String manyToManyOrderByTemplate;
    private final boolean insertCallable;
    private final boolean updateCallable;
    private final boolean deleteCallable;
    private final boolean deleteAllCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private ExecuteUpdateResultCheckStyle deleteAllCheckStyle;
    private final Serializable[] spaces;
    private Map collectionPropertyColumnAliases = new HashMap();
    private Map collectionPropertyColumnNames = new HashMap();
    private static final Log log = LogFactory.getLog((Class)AbstractCollectionPersister.class);

    public AbstractCollectionPersister(Collection collection, CacheConcurrencyStrategy cacheConcurrencyStrategy, Configuration configuration, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException, CacheException {
        Object object;
        Object object2;
        int n;
        this.factory = sessionFactoryImplementor;
        this.cache = cacheConcurrencyStrategy;
        this.cacheEntryStructure = sessionFactoryImplementor.getSettings().isStructuredCacheEntriesEnabled() ? (collection.isMap() ? new StructuredMapCacheEntry() : new StructuredCollectionCacheEntry()) : new UnstructuredCacheEntry();
        this.dialect = sessionFactoryImplementor.getDialect();
        this.sqlExceptionConverter = sessionFactoryImplementor.getSQLExceptionConverter();
        this.collectionType = collection.getCollectionType();
        this.role = collection.getRole();
        this.entityName = collection.getOwnerEntityName();
        this.ownerPersister = sessionFactoryImplementor.getEntityPersister(this.entityName);
        this.queryLoaderName = collection.getLoaderName();
        this.nodeName = collection.getNodeName();
        this.isMutable = collection.isMutable();
        Table table = collection.getCollectionTable();
        this.fetchMode = collection.getElement().getFetchMode();
        this.elementType = collection.getElement().getType();
        this.isPrimitiveArray = collection.isPrimitiveArray();
        this.isArray = collection.isArray();
        this.subselectLoadable = collection.isSubselectLoadable();
        this.qualifiedTableName = table.getQualifiedName(this.dialect, sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
        int n2 = 1 + collection.getSynchronizedTables().size();
        this.spaces = new String[n2];
        this.spaces[0] = this.qualifiedTableName;
        Iterator iterator = collection.getSynchronizedTables().iterator();
        for (n = 1; n < n2; ++n) {
            this.spaces[n] = (String)iterator.next();
        }
        this.sqlOrderByString = collection.getOrderBy();
        this.hasOrder = this.sqlOrderByString != null;
        this.sqlOrderByStringTemplate = this.hasOrder ? Template.renderOrderByStringTemplate(this.sqlOrderByString, this.dialect, sessionFactoryImplementor.getSqlFunctionRegistry()) : null;
        this.sqlWhereString = StringHelper.isNotEmpty(collection.getWhere()) ? "( " + collection.getWhere() + ") " : null;
        this.hasWhere = this.sqlWhereString != null;
        this.sqlWhereStringTemplate = this.hasWhere ? Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect, sessionFactoryImplementor.getSqlFunctionRegistry()) : null;
        this.hasOrphanDelete = collection.hasOrphanDelete();
        n = collection.getBatchSize();
        if (n == -1) {
            n = sessionFactoryImplementor.getSettings().getDefaultBatchFetchSize();
        }
        this.batchSize = n;
        this.isVersioned = collection.isOptimisticLocked();
        this.keyType = collection.getKey().getType();
        iterator = collection.getKey().getColumnIterator();
        int n3 = collection.getKey().getColumnSpan();
        this.keyColumnNames = new String[n3];
        this.keyColumnAliases = new String[n3];
        int n4 = 0;
        while (iterator.hasNext()) {
            object2 = (Column)iterator.next();
            this.keyColumnNames[n4] = ((Column)object2).getQuotedName(this.dialect);
            this.keyColumnAliases[n4] = ((Column)object2).getAlias(this.dialect);
            ++n4;
        }
        object2 = collection.getElementNodeName();
        if (this.elementType.isEntityType()) {
            String string = ((EntityType)this.elementType).getAssociatedEntityName();
            this.elementPersister = sessionFactoryImplementor.getEntityPersister(string);
            if (object2 == null) {
                object2 = configuration.getClassMapping(string).getNodeName();
            }
        } else {
            this.elementPersister = null;
        }
        this.elementNodeName = object2;
        int n5 = collection.getElement().getColumnSpan();
        this.elementColumnAliases = new String[n5];
        this.elementColumnNames = new String[n5];
        this.elementFormulaTemplates = new String[n5];
        this.elementFormulas = new String[n5];
        this.elementColumnIsSettable = new boolean[n5];
        this.elementColumnIsInPrimaryKey = new boolean[n5];
        boolean bl = true;
        boolean bl2 = false;
        int n6 = 0;
        iterator = collection.getElement().getColumnIterator();
        while (iterator.hasNext()) {
            Selectable selectable;
            object = (Selectable)iterator.next();
            this.elementColumnAliases[n6] = object.getAlias(this.dialect);
            if (object.isFormula()) {
                selectable = (Formula)object;
                this.elementFormulaTemplates[n6] = ((Formula)selectable).getTemplate(this.dialect, sessionFactoryImplementor.getSqlFunctionRegistry());
                this.elementFormulas[n6] = ((Formula)selectable).getFormula();
            } else {
                selectable = (Column)object;
                this.elementColumnNames[n6] = ((Column)selectable).getQuotedName(this.dialect);
                this.elementColumnIsSettable[n6] = true;
                boolean bl3 = this.elementColumnIsInPrimaryKey[n6] = !((Column)selectable).isNullable();
                if (!((Column)selectable).isNullable()) {
                    bl2 = true;
                }
                bl = false;
            }
            ++n6;
        }
        this.elementIsPureFormula = bl;
        if (!bl2) {
            Arrays.fill(this.elementColumnIsInPrimaryKey, true);
        }
        this.hasIndex = collection.isIndexed();
        if (this.hasIndex) {
            object = (IndexedCollection)collection;
            this.indexType = ((IndexedCollection)object).getIndex().getType();
            int n7 = ((IndexedCollection)object).getIndex().getColumnSpan();
            iterator = ((IndexedCollection)object).getIndex().getColumnIterator();
            this.indexColumnNames = new String[n7];
            this.indexFormulaTemplates = new String[n7];
            this.indexFormulas = new String[n7];
            this.indexColumnIsSettable = new boolean[n7];
            this.indexColumnAliases = new String[n7];
            int n8 = 0;
            boolean bl4 = false;
            while (iterator.hasNext()) {
                Selectable selectable;
                Selectable selectable2 = (Selectable)iterator.next();
                this.indexColumnAliases[n8] = selectable2.getAlias(this.dialect);
                if (selectable2.isFormula()) {
                    selectable = (Formula)selectable2;
                    this.indexFormulaTemplates[n8] = ((Formula)selectable).getTemplate(this.dialect, sessionFactoryImplementor.getSqlFunctionRegistry());
                    this.indexFormulas[n8] = ((Formula)selectable).getFormula();
                    bl4 = true;
                } else {
                    selectable = (Column)selectable2;
                    this.indexColumnNames[n8] = ((Column)selectable).getQuotedName(this.dialect);
                    this.indexColumnIsSettable[n8] = true;
                }
                ++n8;
            }
            this.indexContainsFormula = bl4;
            this.baseIndex = ((IndexedCollection)object).isList() ? ((List)object).getBaseIndex() : 0;
            this.indexNodeName = ((IndexedCollection)object).getIndexNodeName();
        } else {
            this.indexContainsFormula = false;
            this.indexColumnIsSettable = null;
            this.indexFormulaTemplates = null;
            this.indexFormulas = null;
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
            this.baseIndex = 0;
            this.indexNodeName = null;
        }
        this.hasIdentifier = collection.isIdentified();
        if (this.hasIdentifier) {
            if (collection.isOneToMany()) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            object = (IdentifierCollection)collection;
            this.identifierType = ((IdentifierCollection)object).getIdentifier().getType();
            iterator = ((IdentifierCollection)object).getIdentifier().getColumnIterator();
            Column column = (Column)iterator.next();
            this.identifierColumnName = column.getQuotedName(this.dialect);
            this.identifierColumnAlias = column.getAlias(this.dialect);
            this.identifierGenerator = ((IdentifierCollection)object).getIdentifier().createIdentifierGenerator(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName(), null);
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.identifierGenerator = null;
        }
        if (collection.getCustomSQLInsert() == null) {
            this.sqlInsertRowString = this.generateInsertRowString();
            this.insertCallable = false;
            this.insertCheckStyle = ExecuteUpdateResultCheckStyle.COUNT;
        } else {
            this.sqlInsertRowString = collection.getCustomSQLInsert();
            this.insertCallable = collection.isCustomInsertCallable();
            ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = this.insertCheckStyle = collection.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(collection.getCustomSQLInsert(), this.insertCallable) : collection.getCustomSQLInsertCheckStyle();
        }
        if (collection.getCustomSQLUpdate() == null) {
            this.sqlUpdateRowString = this.generateUpdateRowString();
            this.updateCallable = false;
            this.updateCheckStyle = ExecuteUpdateResultCheckStyle.COUNT;
        } else {
            this.sqlUpdateRowString = collection.getCustomSQLUpdate();
            this.updateCallable = collection.isCustomUpdateCallable();
            ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = this.updateCheckStyle = collection.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(collection.getCustomSQLUpdate(), this.insertCallable) : collection.getCustomSQLUpdateCheckStyle();
        }
        if (collection.getCustomSQLDelete() == null) {
            this.sqlDeleteRowString = this.generateDeleteRowString();
            this.deleteCallable = false;
            this.deleteCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        } else {
            this.sqlDeleteRowString = collection.getCustomSQLDelete();
            this.deleteCallable = collection.isCustomDeleteCallable();
            this.deleteCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        }
        if (collection.getCustomSQLDeleteAll() == null) {
            this.sqlDeleteString = this.generateDeleteString();
            this.deleteAllCallable = false;
            this.deleteAllCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        } else {
            this.sqlDeleteString = collection.getCustomSQLDeleteAll();
            this.deleteAllCallable = collection.isCustomDeleteAllCallable();
            this.deleteAllCheckStyle = ExecuteUpdateResultCheckStyle.NONE;
        }
        this.sqlSelectSizeString = this.generateSelectSizeString(collection.isIndexed() && !collection.isMap());
        this.sqlDetectRowByIndexString = this.generateDetectRowByIndexString();
        this.sqlDetectRowByElementString = this.generateDetectRowByElementString();
        this.sqlSelectRowByIndexString = this.generateSelectRowByIndexString();
        this.logStaticSQL();
        this.isLazy = collection.isLazy();
        this.isExtraLazy = collection.isExtraLazy();
        this.isInverse = collection.isInverse();
        this.elementClass = collection.isArray() ? ((Array)collection).getElementClass() : null;
        this.elementPropertyMapping = this.elementType.isComponentType() ? new CompositeElementPropertyMapping(this.elementColumnNames, this.elementFormulaTemplates, (AbstractComponentType)this.elementType, sessionFactoryImplementor) : (!this.elementType.isEntityType() ? new ElementPropertyMapping(this.elementColumnNames, this.elementType) : (this.elementPersister instanceof PropertyMapping ? (PropertyMapping)((Object)this.elementPersister) : new ElementPropertyMapping(this.elementColumnNames, this.elementType)));
        this.filterHelper = new FilterHelper(collection.getFilterMap(), this.dialect, sessionFactoryImplementor.getSqlFunctionRegistry());
        this.manyToManyFilterHelper = new FilterHelper(collection.getManyToManyFilterMap(), this.dialect, sessionFactoryImplementor.getSqlFunctionRegistry());
        this.manyToManyWhereString = StringHelper.isNotEmpty(collection.getManyToManyWhere()) ? "( " + collection.getManyToManyWhere() + " )" : null;
        this.manyToManyWhereTemplate = this.manyToManyWhereString == null ? null : Template.renderWhereStringTemplate(this.manyToManyWhereString, sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
        this.manyToManyOrderByString = collection.getManyToManyOrdering();
        this.manyToManyOrderByTemplate = this.manyToManyOrderByString == null ? null : Template.renderOrderByStringTemplate(this.manyToManyOrderByString, sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
        this.initCollectionPropertyMap();
    }

    public void postInstantiate() throws MappingException {
        this.initializer = this.queryLoaderName == null ? this.createCollectionInitializer(CollectionHelper.EMPTY_MAP) : new NamedQueryCollectionInitializer(this.queryLoaderName, this);
    }

    protected void logStaticSQL() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Static SQL for collection: " + this.getRole()));
            if (this.getSQLInsertRowString() != null) {
                log.debug((Object)(" Row insert: " + this.getSQLInsertRowString()));
            }
            if (this.getSQLUpdateRowString() != null) {
                log.debug((Object)(" Row update: " + this.getSQLUpdateRowString()));
            }
            if (this.getSQLDeleteRowString() != null) {
                log.debug((Object)(" Row delete: " + this.getSQLDeleteRowString()));
            }
            if (this.getSQLDeleteString() != null) {
                log.debug((Object)(" One-shot delete: " + this.getSQLDeleteString()));
            }
        }
    }

    public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        this.getAppropriateInitializer(serializable, sessionImplementor).initialize(serializable, sessionImplementor);
    }

    protected CollectionInitializer getAppropriateInitializer(Serializable serializable, SessionImplementor sessionImplementor) {
        if (this.queryLoaderName != null) {
            return this.initializer;
        }
        CollectionInitializer collectionInitializer = this.getSubselectInitializer(serializable, sessionImplementor);
        if (collectionInitializer != null) {
            return collectionInitializer;
        }
        if (sessionImplementor.getEnabledFilters().isEmpty()) {
            return this.initializer;
        }
        return this.createCollectionInitializer(sessionImplementor.getEnabledFilters());
    }

    private CollectionInitializer getSubselectInitializer(Serializable serializable, SessionImplementor sessionImplementor) {
        if (!this.isSubselectLoadable()) {
            return null;
        }
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        SubselectFetch subselectFetch = persistenceContext.getBatchFetchQueue().getSubselect(new EntityKey(serializable, this.getOwnerEntityPersister(), sessionImplementor.getEntityMode()));
        if (subselectFetch == null) {
            return null;
        }
        Iterator iterator = subselectFetch.getResult().iterator();
        while (iterator.hasNext()) {
            if (persistenceContext.containsEntity((EntityKey)iterator.next())) continue;
            iterator.remove();
        }
        return this.createSubselectInitializer(subselectFetch, sessionImplementor);
    }

    protected abstract CollectionInitializer createSubselectInitializer(SubselectFetch var1, SessionImplementor var2);

    protected abstract CollectionInitializer createCollectionInitializer(Map var1) throws MappingException;

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    protected String getSQLWhereString(String string) {
        return StringHelper.replace(this.sqlWhereStringTemplate, "$PlaceHolder$", string);
    }

    public String getSQLOrderByString(String string) {
        return this.hasOrdering() ? StringHelper.replace(this.sqlOrderByStringTemplate, "$PlaceHolder$", string) : "";
    }

    public String getManyToManyOrderByString(String string) {
        if (this.isManyToMany() && this.manyToManyOrderByString != null) {
            return StringHelper.replace(this.manyToManyOrderByTemplate, "$PlaceHolder$", string);
        }
        return "";
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public boolean hasOrdering() {
        return this.hasOrder;
    }

    public boolean hasManyToManyOrdering() {
        return this.isManyToMany() && this.manyToManyOrderByTemplate != null;
    }

    public boolean hasWhere() {
        return this.hasWhere;
    }

    protected String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    protected String getSQLInsertRowString() {
        return this.sqlInsertRowString;
    }

    protected String getSQLUpdateRowString() {
        return this.sqlUpdateRowString;
    }

    protected String getSQLDeleteRowString() {
        return this.sqlDeleteRowString;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getIndexType() {
        return this.indexType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Object readElement(ResultSet resultSet, Object object, String[] stringArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        return this.getElementType().nullSafeGet(resultSet, stringArray, sessionImplementor, object);
    }

    public Object readIndex(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Object object = this.getIndexType().nullSafeGet(resultSet, stringArray, sessionImplementor, null);
        if (object == null) {
            throw new HibernateException("null index column for collection: " + this.role);
        }
        object = this.decrementIndexByBase(object);
        return object;
    }

    protected Object decrementIndexByBase(Object object) {
        if (this.baseIndex != 0) {
            object = new Integer((Integer)object - this.baseIndex);
        }
        return object;
    }

    public Object readIdentifier(ResultSet resultSet, String string, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        Object object = this.getIdentifierType().nullSafeGet(resultSet, string, sessionImplementor, null);
        if (object == null) {
            throw new HibernateException("null identifier column for collection: " + this.role);
        }
        return object;
    }

    public Object readKey(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        return this.getKeyType().nullSafeGet(resultSet, stringArray, sessionImplementor, null);
    }

    protected int writeKey(PreparedStatement preparedStatement, Serializable serializable, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (serializable == null) {
            throw new NullPointerException("null key for collection: " + this.role);
        }
        this.getKeyType().nullSafeSet(preparedStatement, serializable, n, sessionImplementor);
        return n + this.keyColumnAliases.length;
    }

    protected int writeElement(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.getElementType().nullSafeSet(preparedStatement, object, n, this.elementColumnIsSettable, sessionImplementor);
        return n + ArrayHelper.countTrue(this.elementColumnIsSettable);
    }

    protected int writeIndex(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.getIndexType().nullSafeSet(preparedStatement, this.incrementIndexByBase(object), n, this.indexColumnIsSettable, sessionImplementor);
        return n + ArrayHelper.countTrue(this.indexColumnIsSettable);
    }

    protected Object incrementIndexByBase(Object object) {
        if (this.baseIndex != 0) {
            object = new Integer((Integer)object + this.baseIndex);
        }
        return object;
    }

    protected int writeElementToWhere(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (this.elementIsPureFormula) {
            throw new AssertionFailure("cannot use a formula-based element in the where condition");
        }
        this.getElementType().nullSafeSet(preparedStatement, object, n, this.elementColumnIsInPrimaryKey, sessionImplementor);
        return n + this.elementColumnAliases.length;
    }

    protected int writeIndexToWhere(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (this.indexContainsFormula) {
            throw new AssertionFailure("cannot use a formula-based index in the where condition");
        }
        this.getIndexType().nullSafeSet(preparedStatement, this.incrementIndexByBase(object), n, sessionImplementor);
        return n + this.indexColumnAliases.length;
    }

    public int writeIdentifier(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.getIdentifierType().nullSafeSet(preparedStatement, object, n, sessionImplementor);
        return n + 1;
    }

    public boolean isPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public String[] getKeyColumnAliases(String string) {
        return new Alias(string).toAliasStrings(this.keyColumnAliases);
    }

    public String[] getElementColumnAliases(String string) {
        return new Alias(string).toAliasStrings(this.elementColumnAliases);
    }

    public String[] getIndexColumnAliases(String string) {
        if (this.hasIndex) {
            return new Alias(string).toAliasStrings(this.indexColumnAliases);
        }
        return null;
    }

    public String getIdentifierColumnAlias(String string) {
        if (this.hasIdentifier) {
            return new Alias(string).toAliasString(this.identifierColumnAlias);
        }
        return null;
    }

    public String getIdentifierColumnName() {
        if (this.hasIdentifier) {
            return this.identifierColumnName;
        }
        return null;
    }

    public String selectFragment(String string, String string2) {
        SelectFragment selectFragment = this.generateSelectFragment(string, string2);
        this.appendElementColumns(selectFragment, string);
        this.appendIndexColumns(selectFragment, string);
        this.appendIdentifierColumns(selectFragment, string);
        return selectFragment.toFragmentString().substring(2);
    }

    protected String generateSelectSizeString(boolean bl) {
        String string = bl ? "max(" + this.getIndexColumnNames()[0] + ") + 1" : "count(" + this.getElementColumnNames()[0] + ")";
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addColumn(string).toStatementString();
    }

    protected String generateDetectRowByIndexString() {
        if (!this.hasIndex()) {
            return null;
        }
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getIndexColumnNames(), "=?").addCondition(this.indexFormulas, "=?").addColumn("1").toStatementString();
    }

    protected String generateSelectRowByIndexString() {
        if (!this.hasIndex()) {
            return null;
        }
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getIndexColumnNames(), "=?").addCondition(this.indexFormulas, "=?").addColumns(this.getElementColumnNames(), this.elementColumnAliases).addColumns(this.indexFormulas, this.indexColumnAliases).toStatementString();
    }

    protected String generateDetectRowByElementString() {
        return new SimpleSelect(this.dialect).setTableName(this.getTableName()).addCondition(this.getKeyColumnNames(), "=?").addCondition(this.getElementColumnNames(), "=?").addCondition(this.elementFormulas, "=?").addColumn("1").toStatementString();
    }

    protected SelectFragment generateSelectFragment(String string, String string2) {
        return new SelectFragment().setSuffix(string2).addColumns(string, this.keyColumnNames, this.keyColumnAliases);
    }

    protected void appendElementColumns(SelectFragment selectFragment, String string) {
        for (int i = 0; i < this.elementColumnIsSettable.length; ++i) {
            if (this.elementColumnIsSettable[i]) {
                selectFragment.addColumn(string, this.elementColumnNames[i], this.elementColumnAliases[i]);
                continue;
            }
            selectFragment.addFormula(string, this.elementFormulaTemplates[i], this.elementColumnAliases[i]);
        }
    }

    protected void appendIndexColumns(SelectFragment selectFragment, String string) {
        if (this.hasIndex) {
            for (int i = 0; i < this.indexColumnIsSettable.length; ++i) {
                if (this.indexColumnIsSettable[i]) {
                    selectFragment.addColumn(string, this.indexColumnNames[i], this.indexColumnAliases[i]);
                    continue;
                }
                selectFragment.addFormula(string, this.indexFormulaTemplates[i], this.indexColumnAliases[i]);
            }
        }
    }

    protected void appendIdentifierColumns(SelectFragment selectFragment, String string) {
        if (this.hasIdentifier) {
            selectFragment.addColumn(string, this.identifierColumnName, this.identifierColumnAlias);
        }
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String[] getIndexFormulas() {
        return this.indexFormulas;
    }

    public String[] getIndexColumnNames(String string) {
        return AbstractCollectionPersister.qualify(string, this.indexColumnNames, this.indexFormulaTemplates);
    }

    public String[] getElementColumnNames(String string) {
        return AbstractCollectionPersister.qualify(string, this.elementColumnNames, this.elementFormulaTemplates);
    }

    private static String[] qualify(String string, String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = stringArray[i] == null ? StringHelper.replace(stringArray2[i], "$PlaceHolder$", string) : StringHelper.qualify(string, stringArray[i]);
        }
        return stringArray3;
    }

    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public String getTableName() {
        return this.qualifiedTableName;
    }

    public void remove(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (!this.isInverse && this.isRowDeleteEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory())));
            }
            try {
                int n = 1;
                PreparedStatement preparedStatement = null;
                Expectation expectation = Expectations.appropriateExpectation(this.getDeleteAllCheckStyle());
                boolean bl = this.isDeleteAllCallable();
                boolean bl2 = expectation.canBeBatched();
                String string = this.getSQLDeleteString();
                preparedStatement = bl2 ? (bl ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string)) : (bl ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string));
                try {
                    this.writeKey(preparedStatement, serializable, n += expectation.prepare(preparedStatement), sessionImplementor);
                    if (bl2) {
                        sessionImplementor.getBatcher().addToBatch(expectation);
                    } else {
                        expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                    }
                }
                catch (SQLException sQLException) {
                    if (bl2) {
                        sessionImplementor.getBatcher().abortBatch(sQLException);
                    }
                    throw sQLException;
                }
                finally {
                    if (!bl2) {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"done deleting collection");
                }
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sQLException, "could not delete collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.getSQLDeleteString());
            }
        }
    }

    public void recreate(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        block21: {
            if (!this.isInverse && this.isRowInsertEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory())));
                }
                try {
                    Iterator iterator = persistentCollection.entries(this);
                    if (iterator.hasNext()) {
                        persistentCollection.preInsert(this);
                        int n = 0;
                        int n2 = 0;
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (persistentCollection.entryExists(e, n)) {
                                int n3 = 1;
                                PreparedStatement preparedStatement = null;
                                Expectation expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
                                boolean bl = this.isInsertCallable();
                                boolean bl2 = expectation.canBeBatched();
                                String string = this.getSQLInsertRowString();
                                preparedStatement = bl2 ? (bl ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string)) : (bl ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string));
                                try {
                                    int n4 = this.writeKey(preparedStatement, serializable, n3 += expectation.prepare(preparedStatement), sessionImplementor);
                                    if (this.hasIdentifier) {
                                        n4 = this.writeIdentifier(preparedStatement, persistentCollection.getIdentifier(e, n), n4, sessionImplementor);
                                    }
                                    if (this.hasIndex) {
                                        n4 = this.writeIndex(preparedStatement, persistentCollection.getIndex(e, n, this), n4, sessionImplementor);
                                    }
                                    n4 = this.writeElement(preparedStatement, persistentCollection.getElement(e), n4, sessionImplementor);
                                    if (bl2) {
                                        sessionImplementor.getBatcher().addToBatch(expectation);
                                    } else {
                                        expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                                    }
                                    persistentCollection.afterRowInsert(this, e, n);
                                    ++n2;
                                }
                                catch (SQLException sQLException) {
                                    if (bl2) {
                                        sessionImplementor.getBatcher().abortBatch(sQLException);
                                    }
                                    throw sQLException;
                                }
                                finally {
                                    if (!bl2) {
                                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                                    }
                                }
                            }
                            ++n;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("done inserting collection: " + n2 + " rows inserted"));
                        }
                        break block21;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"collection was empty");
                    }
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sQLException, "could not insert collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.getSQLInsertRowString());
                }
            }
        }
    }

    protected boolean isRowDeleteEnabled() {
        return true;
    }

    public void deleteRows(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        block21: {
            if (!this.isInverse && this.isRowDeleteEnabled()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory())));
                }
                boolean bl = !this.isOneToMany() && this.hasIndex && !this.indexContainsFormula;
                try {
                    Iterator iterator = persistentCollection.getDeletes(this, !bl);
                    if (iterator.hasNext()) {
                        int n = 1;
                        int n2 = 0;
                        while (iterator.hasNext()) {
                            PreparedStatement preparedStatement = null;
                            Expectation expectation = Expectations.appropriateExpectation(this.getDeleteCheckStyle());
                            boolean bl2 = this.isDeleteCallable();
                            boolean bl3 = expectation.canBeBatched();
                            String string = this.getSQLDeleteRowString();
                            preparedStatement = bl3 ? (bl2 ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string)) : (bl2 ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string));
                            try {
                                expectation.prepare(preparedStatement);
                                Object e = iterator.next();
                                int n3 = n;
                                if (this.hasIdentifier) {
                                    this.writeIdentifier(preparedStatement, e, n3, sessionImplementor);
                                } else {
                                    n3 = this.writeKey(preparedStatement, serializable, n3, sessionImplementor);
                                    if (bl) {
                                        this.writeIndexToWhere(preparedStatement, e, n3, sessionImplementor);
                                    } else {
                                        this.writeElementToWhere(preparedStatement, e, n3, sessionImplementor);
                                    }
                                }
                                if (bl3) {
                                    sessionImplementor.getBatcher().addToBatch(expectation);
                                } else {
                                    expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                                }
                                ++n2;
                            }
                            catch (SQLException sQLException) {
                                if (bl3) {
                                    sessionImplementor.getBatcher().abortBatch(sQLException);
                                }
                                throw sQLException;
                            }
                            finally {
                                if (!bl3) {
                                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                                }
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("done deleting collection rows: " + n2 + " deleted"));
                        }
                        break block21;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"no rows to delete");
                    }
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sQLException, "could not delete collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.getSQLDeleteRowString());
                }
            }
        }
    }

    protected boolean isRowInsertEnabled() {
        return true;
    }

    public void insertRows(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (!this.isInverse && this.isRowInsertEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inserting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory())));
            }
            try {
                persistentCollection.preInsert(this);
                Iterator iterator = persistentCollection.entries(this);
                Expectation expectation = Expectations.appropriateExpectation(this.getInsertCheckStyle());
                boolean bl = this.isInsertCallable();
                boolean bl2 = expectation.canBeBatched();
                String string = this.getSQLInsertRowString();
                int n = 0;
                int n2 = 0;
                while (iterator.hasNext()) {
                    int n3 = 1;
                    Object e = iterator.next();
                    PreparedStatement preparedStatement = null;
                    if (persistentCollection.needsInserting(e, n, this.elementType)) {
                        if (bl2) {
                            if (preparedStatement == null) {
                                preparedStatement = bl ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string);
                            }
                        } else {
                            preparedStatement = bl ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string);
                        }
                        try {
                            n3 += expectation.prepare(preparedStatement);
                            n3 = this.writeKey(preparedStatement, serializable, n3, sessionImplementor);
                            if (this.hasIdentifier) {
                                n3 = this.writeIdentifier(preparedStatement, persistentCollection.getIdentifier(e, n), n3, sessionImplementor);
                            }
                            if (this.hasIndex) {
                                n3 = this.writeIndex(preparedStatement, persistentCollection.getIndex(e, n, this), n3, sessionImplementor);
                            }
                            this.writeElement(preparedStatement, persistentCollection.getElement(e), n3, sessionImplementor);
                            if (bl2) {
                                sessionImplementor.getBatcher().addToBatch(expectation);
                            } else {
                                expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                            }
                            persistentCollection.afterRowInsert(this, e, n);
                            ++n2;
                        }
                        catch (SQLException sQLException) {
                            if (bl2) {
                                sessionImplementor.getBatcher().abortBatch(sQLException);
                            }
                            throw sQLException;
                        }
                        finally {
                            if (!bl2) {
                                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                            }
                        }
                    }
                    ++n;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("done inserting rows: " + n2 + " inserted"));
                }
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter, sQLException, "could not insert collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.getSQLInsertRowString());
            }
        }
    }

    public String getRole() {
        return this.role;
    }

    public String getOwnerEntityName() {
        return this.entityName;
    }

    public EntityPersister getOwnerEntityPersister() {
        return this.ownerPersister;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public boolean hasOrphanDelete() {
        return this.hasOrphanDelete;
    }

    public Type toType(String string) throws QueryException {
        if ("index".equals(string)) {
            return this.indexType;
        }
        return this.elementPropertyMapping.toType(string);
    }

    public abstract boolean isManyToMany();

    public String getManyToManyFilterFragment(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        this.manyToManyFilterHelper.render(stringBuffer, string, map);
        if (this.manyToManyWhereString != null) {
            stringBuffer.append(" and ").append(StringHelper.replace(this.manyToManyWhereTemplate, "$PlaceHolder$", string));
        }
        return stringBuffer.toString();
    }

    public String[] toColumns(String string, String string2) throws QueryException {
        if ("index".equals(string2)) {
            if (this.isManyToMany()) {
                throw new QueryException("index() function not supported for many-to-many association");
            }
            return StringHelper.qualify(string, this.indexColumnNames);
        }
        return this.elementPropertyMapping.toColumns(string, string2);
    }

    public String[] toColumns(String string) throws QueryException {
        if ("index".equals(string)) {
            if (this.isManyToMany()) {
                throw new QueryException("index() function not supported for many-to-many association");
            }
            return this.indexColumnNames;
        }
        return this.elementPropertyMapping.toColumns(string);
    }

    public Type getType() {
        return this.elementPropertyMapping.getType();
    }

    public String getName() {
        return this.getRole();
    }

    public EntityPersister getElementPersister() {
        if (this.elementPersister == null) {
            throw new AssertionFailure("not an association");
        }
        return (Loadable)this.elementPersister;
    }

    public boolean isCollection() {
        return true;
    }

    public Serializable[] getCollectionSpaces() {
        return this.spaces;
    }

    protected abstract String generateDeleteString();

    protected abstract String generateDeleteRowString();

    protected abstract String generateUpdateRowString();

    protected abstract String generateInsertRowString();

    public void updateRows(PersistentCollection persistentCollection, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (!this.isInverse && persistentCollection.isRowUpdatePossible()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating rows of collection: " + this.role + "#" + serializable));
            }
            int n = this.doUpdateRows(serializable, persistentCollection, sessionImplementor);
            if (log.isDebugEnabled()) {
                log.debug((Object)("done updating rows: " + n + " updated"));
            }
        }
    }

    protected abstract int doUpdateRows(Serializable var1, PersistentCollection var2, SessionImplementor var3) throws HibernateException;

    public CollectionMetadata getCollectionMetadata() {
        return this;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected String filterFragment(String string) throws MappingException {
        return this.hasWhere() ? " and " + this.getSQLWhereString(string) : "";
    }

    public String filterFragment(String string, Map map) throws MappingException {
        StringBuffer stringBuffer = new StringBuffer();
        this.filterHelper.render(stringBuffer, string, map);
        return stringBuffer.append(this.filterFragment(string)).toString();
    }

    public String oneToManyFilterFragment(String string) throws MappingException {
        return "";
    }

    protected boolean isInsertCallable() {
        return this.insertCallable;
    }

    protected ExecuteUpdateResultCheckStyle getInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    protected boolean isUpdateCallable() {
        return this.updateCallable;
    }

    protected ExecuteUpdateResultCheckStyle getUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    protected boolean isDeleteCallable() {
        return this.deleteCallable;
    }

    protected ExecuteUpdateResultCheckStyle getDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    protected boolean isDeleteAllCallable() {
        return this.deleteAllCallable;
    }

    protected ExecuteUpdateResultCheckStyle getDeleteAllCheckStyle() {
        return this.deleteAllCheckStyle;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.role + ')';
    }

    public boolean isVersioned() {
        return this.isVersioned && this.getOwnerEntityPersister().isVersioned();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getElementNodeName() {
        return this.elementNodeName;
    }

    public String getIndexNodeName() {
        return this.indexNodeName;
    }

    protected SQLExceptionConverter getSQLExceptionConverter() {
        return this.sqlExceptionConverter;
    }

    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    public boolean isAffectedByEnabledFilters(SessionImplementor sessionImplementor) {
        return this.filterHelper.isAffectedBy(sessionImplementor.getEnabledFilters()) || this.isManyToMany() && this.manyToManyFilterHelper.isAffectedBy(sessionImplementor.getEnabledFilters());
    }

    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public String[] getCollectionPropertyColumnAliases(String string, String string2) {
        String[] stringArray = (String[])this.collectionPropertyColumnAliases.get(string);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = new Alias(string2).toUnquotedAliasString(stringArray[i]);
        }
        return stringArray2;
    }

    public void initCollectionPropertyMap() {
        this.initCollectionPropertyMap("key", this.keyType, this.keyColumnAliases, this.keyColumnNames);
        this.initCollectionPropertyMap("element", this.elementType, this.elementColumnAliases, this.elementColumnNames);
        if (this.hasIndex) {
            this.initCollectionPropertyMap("index", this.indexType, this.indexColumnAliases, this.indexColumnNames);
        }
        if (this.hasIdentifier) {
            this.initCollectionPropertyMap("id", this.identifierType, new String[]{this.identifierColumnAlias}, new String[]{this.identifierColumnName});
        }
    }

    private void initCollectionPropertyMap(String string, Type type, String[] stringArray, String[] stringArray2) {
        this.collectionPropertyColumnAliases.put(string, stringArray);
        this.collectionPropertyColumnNames.put(string, stringArray2);
        if (type.isComponentType()) {
            AbstractComponentType abstractComponentType = (AbstractComponentType)type;
            String[] stringArray3 = abstractComponentType.getPropertyNames();
            for (int i = 0; i < stringArray3.length; ++i) {
                String string2 = stringArray3[i];
                this.collectionPropertyColumnAliases.put(string + "." + string2, stringArray[i]);
                this.collectionPropertyColumnNames.put(string + "." + string2, stringArray2[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int getSize(Serializable serializable, SessionImplementor sessionImplementor) {
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sqlSelectSizeString);
            try {
                int n;
                this.getKeyType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    n = resultSet.next() ? resultSet.getInt(1) - this.baseIndex : 0;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return n;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve collection size: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    public boolean indexExists(Serializable serializable, Object object, SessionImplementor sessionImplementor) {
        return this.exists(serializable, this.incrementIndexByBase(object), this.getIndexType(), this.sqlDetectRowByIndexString, sessionImplementor);
    }

    public boolean elementExists(Serializable serializable, Object object, SessionImplementor sessionImplementor) {
        return this.exists(serializable, object, this.getElementType(), this.sqlDetectRowByElementString, sessionImplementor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean exists(Serializable serializable, Object object, Type type, String string, SessionImplementor sessionImplementor) {
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(string);
            try {
                boolean bl;
                this.getKeyType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                type.nullSafeSet(preparedStatement, object, this.keyColumnNames.length + 1, sessionImplementor);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    bl = resultSet.next();
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                        throw throwable;
                    }
                    catch (TransientObjectException transientObjectException) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                resultSet.close();
                return bl;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not check row existence: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object getElementByIndex(Serializable serializable, Object object, SessionImplementor sessionImplementor, Object object2) {
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sqlSelectRowByIndexString);
            try {
                ResultSet resultSet;
                block10: {
                    Object object3;
                    this.getKeyType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                    this.getIndexType().nullSafeSet(preparedStatement, this.incrementIndexByBase(object), this.keyColumnNames.length + 1, sessionImplementor);
                    resultSet = preparedStatement.executeQuery();
                    try {
                        if (!resultSet.next()) break block10;
                        object3 = this.getElementType().nullSafeGet(resultSet, this.elementColumnAliases, sessionImplementor, object2);
                    }
                    catch (Throwable throwable) {
                        resultSet.close();
                        throw throwable;
                    }
                    resultSet.close();
                    return object3;
                }
                Object var7_9 = null;
                resultSet.close();
                return var7_9;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not read row: " + MessageHelper.collectionInfoString((CollectionPersister)this, serializable, this.getFactory()), this.sqlSelectSizeString);
        }
    }

    public boolean isExtraLazy() {
        return this.isExtraLazy;
    }

    protected Dialect getDialect() {
        return this.dialect;
    }
}

