/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class DynamicFilterParameterSpecification
implements ParameterSpecification {
    private final String filterName;
    private final String parameterName;
    private final Type definedParameterType;
    private final int queryParameterPosition;

    public DynamicFilterParameterSpecification(String string, String string2, Type type, int n) {
        this.filterName = string;
        this.parameterName = string2;
        this.definedParameterType = type;
        this.queryParameterPosition = n;
    }

    public int bind(PreparedStatement preparedStatement, QueryParameters queryParameters, SessionImplementor sessionImplementor, int n) throws SQLException {
        Object object = queryParameters.getFilteredPositionalParameterValues()[this.queryParameterPosition];
        this.definedParameterType.nullSafeSet(preparedStatement, object, n, sessionImplementor);
        return this.definedParameterType.getColumnSpan(sessionImplementor.getFactory());
    }

    public Type getExpectedType() {
        return this.definedParameterType;
    }

    public void setExpectedType(Type type) {
    }

    public String renderDisplayInfo() {
        return "dynamic-filter={filterName=" + this.filterName + ",paramName=" + this.parameterName + "}";
    }
}

