/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.TypeFactory;

public class Set
extends Collection {
    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
    }

    public Set(PersistentClass persistentClass) {
        super(persistentClass);
    }

    public boolean isSet() {
        return true;
    }

    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return TypeFactory.sortedSet(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded(), this.getComparator());
        }
        if (this.hasOrder()) {
            return TypeFactory.orderedSet(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
        }
        return TypeFactory.set(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.addColumns(this.getKey().getColumnIterator());
            Iterator iterator = this.getElement().getColumnIterator();
            while (iterator.hasNext()) {
                Column column;
                Object e = iterator.next();
                if (!(e instanceof Column) || (column = (Column)e).isNullable()) continue;
                primaryKey.addColumn(column);
            }
            if (primaryKey.getColumnSpan() != this.getKey().getColumnSpan()) {
                this.getCollectionTable().setPrimaryKey(primaryKey);
            }
        }
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }
}

