/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;

public abstract class IndexedCollection
extends Collection {
    public static final String DEFAULT_INDEX_COLUMN_NAME = "idx";
    private Value index;
    private String indexNodeName;

    public IndexedCollection(PersistentClass persistentClass) {
        super(persistentClass);
    }

    public Value getIndex() {
        return this.index;
    }

    public void setIndex(Value value) {
        this.index = value;
    }

    public final boolean isIndexed() {
        return true;
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.addColumns(this.getKey().getColumnIterator());
            boolean bl = false;
            Iterator iterator = this.getIndex().getColumnIterator();
            while (iterator.hasNext()) {
                if (!((Selectable)iterator.next()).isFormula()) continue;
                bl = true;
            }
            if (bl) {
                primaryKey.addColumns(this.getElement().getColumnIterator());
            } else {
                primaryKey.addColumns(this.getIndex().getColumnIterator());
            }
            this.getCollectionTable().setPrimaryKey(primaryKey);
        }
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIndex().isValid(mapping)) {
            throw new MappingException("collection index mapping has wrong number of columns: " + this.getRole() + " type: " + this.getIndex().getType().getName());
        }
        if (this.indexNodeName != null && !this.indexNodeName.startsWith("@")) {
            throw new MappingException("index node must be an attribute: " + this.indexNodeName);
        }
    }

    public boolean isList() {
        return false;
    }

    public String getIndexNodeName() {
        return this.indexNodeName;
    }

    public void setIndexNodeName(String string) {
        this.indexNodeName = string;
    }
}

