/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;

public class ForeignKey
extends Constraint {
    private Table referencedTable;
    private String referencedEntityName;
    private boolean cascadeDeleteEnabled;
    private List referencedColumns = new ArrayList();

    public String sqlConstraintString(Dialect dialect, String string, String string2, String string3) {
        String[] stringArray = new String[this.getColumnSpan()];
        String[] stringArray2 = new String[this.getColumnSpan()];
        int n = 0;
        Iterator iterator = null;
        iterator = this.isReferenceToPrimaryKey() ? this.referencedTable.getPrimaryKey().getColumnIterator() : this.referencedColumns.iterator();
        Iterator iterator2 = this.getColumnIterator();
        while (iterator2.hasNext()) {
            stringArray[n] = ((Column)iterator2.next()).getQuotedName(dialect);
            stringArray2[n] = ((Column)iterator.next()).getQuotedName(dialect);
            ++n;
        }
        String string4 = dialect.getAddForeignKeyConstraintString(string, stringArray, this.referencedTable.getQualifiedName(dialect, string2, string3), stringArray2, this.isReferenceToPrimaryKey());
        return this.cascadeDeleteEnabled && dialect.supportsCascadeDelete() ? string4 + " on delete cascade" : string4;
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    private void appendColumns(StringBuffer stringBuffer, Iterator iterator) {
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            stringBuffer.append(column.getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
    }

    public void setReferencedTable(Table table) throws MappingException {
        this.referencedTable = table;
    }

    public void alignColumns() {
        if (this.isReferenceToPrimaryKey()) {
            this.alignColumns(this.referencedTable);
        }
    }

    private void alignColumns(Table table) {
        if (table.getPrimaryKey().getColumnSpan() != this.getColumnSpan()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Foreign key (").append(this.getName() + ":").append(this.getTable().getName()).append(" [");
            this.appendColumns(stringBuffer, this.getColumnIterator());
            stringBuffer.append("])").append(") must have same number of columns as the referenced primary key (").append(table.getName()).append(" [");
            this.appendColumns(stringBuffer, table.getPrimaryKey().getColumnIterator());
            stringBuffer.append("])");
            throw new MappingException(stringBuffer.toString());
        }
        Iterator iterator = this.getColumnIterator();
        Iterator iterator2 = table.getPrimaryKey().getColumnIterator();
        while (iterator2.hasNext()) {
            ((Column)iterator.next()).setLength(((Column)iterator2.next()).getLength());
        }
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String string) {
        this.referencedEntityName = string;
    }

    public String sqlDropString(Dialect dialect, String string, String string2) {
        return "alter table " + this.getTable().getQualifiedName(dialect, string, string2) + dialect.getDropForeignKeyString() + this.getName();
    }

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public void setCascadeDeleteEnabled(boolean bl) {
        this.cascadeDeleteEnabled = bl;
    }

    public boolean isPhysicalConstraint() {
        return this.referencedTable.isPhysicalTable() && this.getTable().isPhysicalTable() && !this.referencedTable.hasDenormalizedTables();
    }

    public List getReferencedColumns() {
        return this.referencedColumns;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.referencedColumns.isEmpty();
    }

    public void addReferencedColumns(Iterator iterator) {
        while (iterator.hasNext()) {
            Selectable selectable = (Selectable)iterator.next();
            if (selectable.isFormula()) continue;
            this.addReferencedColumn((Column)selectable);
        }
    }

    private void addReferencedColumn(Column column) {
        if (!this.referencedColumns.contains(column)) {
            this.referencedColumns.add(column);
        }
    }

    public String toString() {
        if (!this.isReferenceToPrimaryKey()) {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName() + '(' + this.getTable().getName() + this.getColumns());
            stringBuffer.append(" ref-columns:(" + this.getReferencedColumns());
            stringBuffer.append(") as " + this.getName());
            return stringBuffer.toString();
        }
        return super.toString();
    }
}

