/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;

public abstract class Constraint
implements RelationalModel,
Serializable {
    private String name;
    private final List columns = new ArrayList();
    private Table table;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Iterator iterator) {
        while (iterator.hasNext()) {
            Selectable selectable = (Selectable)iterator.next();
            if (selectable.isFormula()) continue;
            this.addColumn((Column)selectable);
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Column getColumn(int n) {
        return (Column)this.columns.get(n);
    }

    public Iterator columnIterator() {
        return this.columns.iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public boolean isGenerated(Dialect dialect) {
        return true;
    }

    public String sqlDropString(Dialect dialect, String string, String string2) {
        if (this.isGenerated(dialect)) {
            return "alter table " + this.getTable().getQualifiedName(dialect, string, string2) + " drop constraint " + this.getName();
        }
        return null;
    }

    public String sqlCreateString(Dialect dialect, Mapping mapping, String string, String string2) {
        if (this.isGenerated(dialect)) {
            String string3 = this.sqlConstraintString(dialect, this.getName(), string, string2);
            StringBuffer stringBuffer = new StringBuffer("alter table ").append(this.getTable().getQualifiedName(dialect, string, string2)).append(string3);
            return stringBuffer.toString();
        }
        return null;
    }

    public List getColumns() {
        return this.columns;
    }

    public abstract String sqlConstraintString(Dialect var1, String var2, String var3, String var4);

    public String toString() {
        return this.getClass().getName() + '(' + this.getTable().getName() + this.getColumns() + ") as " + this.name;
    }
}

