/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.tuple.component.ComponentMetamodel;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.Type;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;

public class Component
extends SimpleValue
implements MetaAttributable {
    private ArrayList properties = new ArrayList();
    private String componentClassName;
    private boolean embedded;
    private String parentProperty;
    private PersistentClass owner;
    private boolean dynamic;
    private Map metaAttributes;
    private String nodeName;
    private boolean isKey;
    private String roleName;
    private Map tuplizerImpls;
    private Type type;

    public Component(PersistentClass persistentClass) throws MappingException {
        super(persistentClass.getTable());
        this.owner = persistentClass;
    }

    public Component(Component component) throws MappingException {
        super(component.getTable());
        this.owner = component.getOwner();
    }

    public Component(Join join) throws MappingException {
        super(join.getTable());
        this.owner = join.getPersistentClass();
    }

    public Component(Collection collection) throws MappingException {
        super(collection.getCollectionTable());
        this.owner = collection.getOwner();
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    public Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    public int getColumnSpan() {
        int n = 0;
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            n += property.getColumnSpan();
        }
        return n;
    }

    public Iterator getColumnIterator() {
        Iterator[] iteratorArray = new Iterator[this.getPropertySpan()];
        Iterator iterator = this.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            iteratorArray[n++] = ((Property)iterator.next()).getColumnIterator();
        }
        return new JoinedIterator(iteratorArray);
    }

    public void setTypeByReflection(String string, String string2) {
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public Class getComponentClass() throws MappingException {
        try {
            return ReflectHelper.classForName(this.componentClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("component class not found: " + this.componentClassName, classNotFoundException);
        }
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public String getParentProperty() {
        return this.parentProperty;
    }

    public void setComponentClassName(String string) {
        this.componentClassName = string;
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public void setOwner(PersistentClass persistentClass) {
        this.owner = persistentClass;
    }

    public void setParentProperty(String string) {
        this.parentProperty = string;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean bl) {
        this.dynamic = bl;
    }

    public Type getType() throws MappingException {
        if (this.type == null) {
            this.type = this.buildType();
        }
        return this.type;
    }

    private Type buildType() {
        ComponentMetamodel componentMetamodel = new ComponentMetamodel(this);
        if (this.isEmbedded()) {
            return new EmbeddedComponentType(componentMetamodel);
        }
        return new ComponentType(componentMetamodel);
    }

    public void setTypeUsingReflection(String string, String string2) throws MappingException {
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public MetaAttribute getMetaAttribute(String string) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(string);
    }

    public void setMetaAttributes(Map map) {
        this.metaAttributes = map;
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }

    public boolean[] getColumnInsertability() {
        boolean[] blArray = new boolean[this.getColumnSpan()];
        Iterator iterator = this.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            boolean[] blArray2 = property.getValue().getColumnInsertability();
            if (property.isInsertable()) {
                System.arraycopy(blArray2, 0, blArray, n, blArray2.length);
            }
            n += blArray2.length;
        }
        return blArray;
    }

    public boolean[] getColumnUpdateability() {
        boolean[] blArray = new boolean[this.getColumnSpan()];
        Iterator iterator = this.getPropertyIterator();
        int n = 0;
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            boolean[] blArray2 = property.getValue().getColumnUpdateability();
            if (property.isUpdateable()) {
                System.arraycopy(blArray2, 0, blArray, n, blArray2.length);
            }
            n += blArray2.length;
        }
        return blArray;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean bl) {
        this.isKey = bl;
    }

    public boolean hasPojoRepresentation() {
        return this.componentClassName != null;
    }

    public void addTuplizer(EntityMode entityMode, String string) {
        if (this.tuplizerImpls == null) {
            this.tuplizerImpls = new HashMap();
        }
        this.tuplizerImpls.put(entityMode, string);
    }

    public String getTuplizerImplClassName(EntityMode entityMode) {
        if (this.tuplizerImpls == null) {
            return null;
        }
        return (String)this.tuplizerImpls.get(entityMode);
    }

    public Map getTuplizerMap() {
        if (this.tuplizerImpls == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.tuplizerImpls);
    }

    public Property getProperty(String string) throws MappingException {
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals(string)) continue;
            return property;
        }
        throw new MappingException("component property not found: " + string);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.properties.toString() + ')';
    }
}

