/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.ReflectHelper;

public abstract class Collection
implements Fetchable,
Value,
Filterable {
    public static final String DEFAULT_ELEMENT_COLUMN_NAME = "elt";
    public static final String DEFAULT_KEY_COLUMN_NAME = "id";
    private KeyValue key;
    private Value element;
    private Table collectionTable;
    private String role;
    private boolean lazy;
    private boolean extraLazy;
    private boolean inverse;
    private boolean mutable = true;
    private boolean subselectLoadable;
    private String cacheConcurrencyStrategy;
    private String cacheRegionName;
    private String orderBy;
    private String where;
    private String manyToManyWhere;
    private String manyToManyOrderBy;
    private PersistentClass owner;
    private String referencedPropertyName;
    private String nodeName;
    private String elementNodeName;
    private boolean sorted;
    private Comparator comparator;
    private String comparatorClassName;
    private boolean orphanDelete;
    private int batchSize = -1;
    private FetchMode fetchMode;
    private boolean embedded = true;
    private boolean optimisticLocked = true;
    private Class collectionPersisterClass;
    private String typeName;
    private final Map filters = new HashMap();
    private final Map manyToManyFilters = new HashMap();
    private final Set synchronizedTables = new HashSet();
    private String customSQLInsert;
    private boolean customInsertCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private String customSQLUpdate;
    private boolean customUpdateCallable;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private String customSQLDelete;
    private boolean customDeleteCallable;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private String customSQLDeleteAll;
    private boolean customDeleteAllCallable;
    private ExecuteUpdateResultCheckStyle deleteAllCheckStyle;
    private String loaderName;

    protected Collection(PersistentClass persistentClass) {
        this.owner = persistentClass;
    }

    public boolean isSet() {
        return false;
    }

    public KeyValue getKey() {
        return this.key;
    }

    public Value getElement() {
        return this.element;
    }

    public boolean isIndexed() {
        return false;
    }

    public Table getCollectionTable() {
        return this.collectionTable;
    }

    public void setCollectionTable(Table table) {
        this.collectionTable = table;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public Comparator getComparator() {
        if (this.comparator == null && this.comparatorClassName != null) {
            try {
                this.setComparator((Comparator)ReflectHelper.classForName(this.comparatorClassName).newInstance());
            }
            catch (Exception exception) {
                throw new MappingException("Could not instantiate comparator class [" + this.comparatorClassName + "] for collection " + this.getRole());
            }
        }
        return this.comparator;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public String getRole() {
        return this.role;
    }

    public abstract CollectionType getDefaultCollectionType() throws MappingException;

    public boolean isPrimitiveArray() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean hasFormula() {
        return false;
    }

    public boolean isOneToMany() {
        return this.element instanceof OneToMany;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public String getOwnerEntityName() {
        return this.owner.getEntityName();
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setElement(Value value) {
        this.element = value;
    }

    public void setKey(KeyValue keyValue) {
        this.key = keyValue;
    }

    public void setOrderBy(String string) {
        this.orderBy = string;
    }

    public void setRole(String string) {
        this.role = string == null ? null : string.intern();
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public void setOwner(PersistentClass persistentClass) {
        this.owner = persistentClass;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String string) {
        this.where = string;
    }

    public String getManyToManyWhere() {
        return this.manyToManyWhere;
    }

    public void setManyToManyWhere(String string) {
        this.manyToManyWhere = string;
    }

    public String getManyToManyOrdering() {
        return this.manyToManyOrderBy;
    }

    public void setManyToManyOrdering(String string) {
        this.manyToManyOrderBy = string;
    }

    public boolean isIdentified() {
        return false;
    }

    public boolean hasOrphanDelete() {
        return this.orphanDelete;
    }

    public void setOrphanDelete(boolean bl) {
        this.orphanDelete = bl;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    public void setFetchMode(FetchMode fetchMode) {
        this.fetchMode = fetchMode;
    }

    public void setCollectionPersisterClass(Class clazz) {
        this.collectionPersisterClass = clazz;
    }

    public Class getCollectionPersisterClass() {
        return this.collectionPersisterClass;
    }

    public void validate(Mapping mapping) throws MappingException {
        if (!(!this.getKey().isCascadeDeleteEnabled() || this.isInverse() && this.isOneToMany())) {
            throw new MappingException("only inverse one-to-many associations may use on-delete=\"cascade\": " + this.getRole());
        }
        if (!this.getKey().isValid(mapping)) {
            throw new MappingException("collection foreign key mapping has wrong number of columns: " + this.getRole() + " type: " + this.getKey().getType().getName());
        }
        if (!this.getElement().isValid(mapping)) {
            throw new MappingException("collection element mapping has wrong number of columns: " + this.getRole() + " type: " + this.getElement().getType().getName());
        }
        this.checkColumnDuplication();
        if (this.elementNodeName != null && this.elementNodeName.startsWith("@")) {
            throw new MappingException("element node must not be an attribute: " + this.elementNodeName);
        }
        if (this.elementNodeName != null && this.elementNodeName.equals(".")) {
            throw new MappingException("element node must not be the parent: " + this.elementNodeName);
        }
        if (this.nodeName != null && this.nodeName.indexOf(64) > -1) {
            throw new MappingException("collection node must not be an attribute: " + this.elementNodeName);
        }
    }

    private void checkColumnDuplication(Set set, Iterator iterator) throws MappingException {
        while (iterator.hasNext()) {
            Column column;
            Selectable selectable = (Selectable)iterator.next();
            if (selectable.isFormula() || set.add((column = (Column)selectable).getName())) continue;
            throw new MappingException("Repeated column in mapping for collection: " + this.getRole() + " column: " + column.getName());
        }
    }

    private void checkColumnDuplication() throws MappingException {
        HashSet hashSet = new HashSet();
        this.checkColumnDuplication(hashSet, this.getKey().getColumnIterator());
        if (this.isIndexed()) {
            this.checkColumnDuplication(hashSet, ((IndexedCollection)this).getIndex().getColumnIterator());
        }
        if (this.isIdentified()) {
            this.checkColumnDuplication(hashSet, ((IdentifierCollection)this).getIdentifier().getColumnIterator());
        }
        if (!this.isOneToMany()) {
            this.checkColumnDuplication(hashSet, this.getElement().getColumnIterator());
        }
    }

    public Iterator getColumnIterator() {
        return EmptyIterator.INSTANCE;
    }

    public int getColumnSpan() {
        return 0;
    }

    public Type getType() throws MappingException {
        return this.getCollectionType();
    }

    public CollectionType getCollectionType() {
        if (this.typeName == null) {
            return this.getDefaultCollectionType();
        }
        return TypeFactory.customCollection(this.typeName, this.role, this.referencedPropertyName, this.isEmbedded());
    }

    public boolean isNullable() {
        return true;
    }

    public boolean isAlternateUniqueKey() {
        return false;
    }

    public Table getTable() {
        return this.owner.getTable();
    }

    public void createForeignKey() {
    }

    public boolean isSimpleValue() {
        return false;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        return true;
    }

    private void createForeignKeys() throws MappingException {
        if (this.referencedPropertyName == null) {
            this.getElement().createForeignKey();
            this.key.createForeignKeyOfEntity(this.getOwner().getEntityName());
        }
    }

    abstract void createPrimaryKey();

    public void createAllKeys() throws MappingException {
        this.createForeignKeys();
        if (!this.isInverse()) {
            this.createPrimaryKey();
        }
    }

    public String getCacheConcurrencyStrategy() {
        return this.cacheConcurrencyStrategy;
    }

    public void setCacheConcurrencyStrategy(String string) {
        this.cacheConcurrencyStrategy = string;
    }

    public void setTypeUsingReflection(String string, String string2) {
    }

    public String getCacheRegionName() {
        return this.cacheRegionName == null ? this.role : this.cacheRegionName;
    }

    public void setCacheRegionName(String string) {
        this.cacheRegionName = string;
    }

    public void setCustomSQLInsert(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLInsert = string;
        this.customInsertCallable = bl;
        this.insertCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public boolean isCustomInsertCallable() {
        return this.customInsertCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    public void setCustomSQLUpdate(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLUpdate = string;
        this.customUpdateCallable = bl;
        this.updateCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public boolean isCustomUpdateCallable() {
        return this.customUpdateCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    public void setCustomSQLDelete(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLDelete = string;
        this.customDeleteCallable = bl;
        this.deleteCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public boolean isCustomDeleteCallable() {
        return this.customDeleteCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    public void setCustomSQLDeleteAll(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLDeleteAll = string;
        this.customDeleteAllCallable = bl;
        this.deleteAllCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLDeleteAll() {
        return this.customSQLDeleteAll;
    }

    public boolean isCustomDeleteAllCallable() {
        return this.customDeleteAllCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteAllCheckStyle() {
        return this.deleteAllCheckStyle;
    }

    public void addFilter(String string, String string2) {
        this.filters.put(string, string2);
    }

    public Map getFilterMap() {
        return this.filters;
    }

    public void addManyToManyFilter(String string, String string2) {
        this.manyToManyFilters.put(string, string2);
    }

    public Map getManyToManyFilterMap() {
        return this.manyToManyFilters;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getRole() + ')';
    }

    public Set getSynchronizedTables() {
        return this.synchronizedTables;
    }

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String string) {
        this.loaderName = string == null ? null : string.intern();
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    public void setReferencedPropertyName(String string) {
        this.referencedPropertyName = string == null ? null : string.intern();
    }

    public boolean isOptimisticLocked() {
        return this.optimisticLocked;
    }

    public void setOptimisticLocked(boolean bl) {
        this.optimisticLocked = bl;
    }

    public boolean isMap() {
        return false;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public boolean[] getColumnInsertability() {
        return ArrayHelper.EMPTY_BOOLEAN_ARRAY;
    }

    public boolean[] getColumnUpdateability() {
        return ArrayHelper.EMPTY_BOOLEAN_ARRAY;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public String getElementNodeName() {
        return this.elementNodeName;
    }

    public void setElementNodeName(String string) {
        this.elementNodeName = string;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public boolean isSubselectLoadable() {
        return this.subselectLoadable;
    }

    public void setSubselectLoadable(boolean bl) {
        this.subselectLoadable = bl;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean bl) {
        this.mutable = bl;
    }

    public boolean isExtraLazy() {
        return this.extraLazy;
    }

    public void setExtraLazy(boolean bl) {
        this.extraLazy = bl;
    }

    public boolean hasOrder() {
        return this.orderBy != null || this.manyToManyOrderBy != null;
    }

    public void setComparatorClassName(String string) {
        this.comparatorClassName = string;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }
}

