/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.mapping.List;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;

public class Array
extends List {
    private String elementClassName;

    public Array(PersistentClass persistentClass) {
        super(persistentClass);
    }

    public Class getElementClass() throws MappingException {
        if (this.elementClassName == null) {
            Type type = this.getElement().getType();
            return this.isPrimitiveArray() ? ((PrimitiveType)type).getPrimitiveClass() : type.getReturnedClass();
        }
        try {
            return ReflectHelper.classForName(this.elementClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException(classNotFoundException);
        }
    }

    public CollectionType getDefaultCollectionType() throws MappingException {
        return TypeFactory.array(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded(), this.getElementClass());
    }

    public boolean isArray() {
        return true;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public void setElementClassName(String string) {
        this.elementClassName = string;
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }
}

