/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lob;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;

public class SerializableBlob
implements Serializable,
Blob {
    private final transient Blob blob;

    public SerializableBlob(Blob blob) {
        this.blob = blob;
    }

    public Blob getWrappedBlob() {
        if (this.blob == null) {
            throw new IllegalStateException("Blobs may not be accessed after serialization");
        }
        return this.blob;
    }

    public long length() throws SQLException {
        return this.getWrappedBlob().length();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        return this.getWrappedBlob().getBytes(l, n);
    }

    public InputStream getBinaryStream() throws SQLException {
        return this.getWrappedBlob().getBinaryStream();
    }

    public long position(byte[] byArray, long l) throws SQLException {
        return this.getWrappedBlob().position(byArray, l);
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.getWrappedBlob().position(blob, l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.getWrappedBlob().setBytes(l, byArray);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        return this.getWrappedBlob().setBytes(l, byArray, n, n2);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        return this.getWrappedBlob().setBinaryStream(l);
    }

    public void truncate(long l) throws SQLException {
        this.getWrappedBlob().truncate(l);
    }
}

