/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.hql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.SelectClause;
import org.hibernate.impl.IteratorImpl;
import org.hibernate.loader.BasicLoader;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class QueryLoader
extends BasicLoader {
    private QueryTranslatorImpl queryTranslator;
    private Queryable[] entityPersisters;
    private String[] entityAliases;
    private String[] sqlAliases;
    private String[] sqlAliasSuffixes;
    private boolean[] includeInSelect;
    private String[] collectionSuffixes;
    private boolean hasScalars;
    private String[][] scalarColumnNames;
    private Type[] queryReturnTypes;
    private final Map sqlAliasByEntityAlias = new HashMap(8);
    private EntityType[] ownerAssociationTypes;
    private int[] owners;
    private boolean[] entityEagerPropertyFetches;
    private int[] collectionOwners;
    private QueryableCollection[] collectionPersisters;
    private int selectLength;
    private ResultTransformer selectNewTransformer;
    private String[] queryReturnAliases;
    private LockMode[] defaultLockModes;

    public QueryLoader(QueryTranslatorImpl queryTranslatorImpl, SessionFactoryImplementor sessionFactoryImplementor, SelectClause selectClause) {
        super(sessionFactoryImplementor);
        this.queryTranslator = queryTranslatorImpl;
        this.initialize(selectClause);
        this.postInstantiate();
    }

    private void initialize(SelectClause selectClause) {
        FromElement fromElement;
        int n;
        int n2;
        List list = selectClause.getFromElementsForLoad();
        this.hasScalars = selectClause.isScalarSelect();
        this.scalarColumnNames = selectClause.getColumnNames();
        this.queryReturnTypes = selectClause.getQueryReturnTypes();
        this.selectNewTransformer = HolderInstantiator.createSelectNewTransformer(selectClause.getConstructor(), selectClause.isMap(), selectClause.isList());
        this.queryReturnAliases = selectClause.getQueryReturnAliases();
        List list2 = selectClause.getCollectionFromElements();
        if (list2 != null && list2.size() != 0) {
            n2 = list2.size();
            this.collectionPersisters = new QueryableCollection[n2];
            this.collectionOwners = new int[n2];
            this.collectionSuffixes = new String[n2];
            for (n = 0; n < n2; ++n) {
                fromElement = (FromElement)list2.get(n);
                this.collectionPersisters[n] = fromElement.getQueryableCollection();
                this.collectionOwners[n] = list.indexOf(fromElement.getOrigin());
                this.collectionSuffixes[n] = fromElement.getCollectionSuffix();
            }
        }
        n2 = list.size();
        this.entityPersisters = new Queryable[n2];
        this.entityEagerPropertyFetches = new boolean[n2];
        this.entityAliases = new String[n2];
        this.sqlAliases = new String[n2];
        this.sqlAliasSuffixes = new String[n2];
        this.includeInSelect = new boolean[n2];
        this.owners = new int[n2];
        this.ownerAssociationTypes = new EntityType[n2];
        for (n = 0; n < n2; ++n) {
            fromElement = (FromElement)list.get(n);
            this.entityPersisters[n] = (Queryable)fromElement.getEntityPersister();
            if (this.entityPersisters[n] == null) {
                throw new IllegalStateException("No entity persister for " + fromElement.toString());
            }
            this.entityEagerPropertyFetches[n] = fromElement.isAllPropertyFetch();
            this.sqlAliases[n] = fromElement.getTableAlias();
            this.entityAliases[n] = fromElement.getClassAlias();
            this.sqlAliasByEntityAlias.put(this.entityAliases[n], this.sqlAliases[n]);
            this.sqlAliasSuffixes[n] = n2 == 1 ? "" : Integer.toString(n) + "_";
            boolean bl = this.includeInSelect[n] = !fromElement.isFetch();
            if (this.includeInSelect[n]) {
                ++this.selectLength;
            }
            this.owners[n] = -1;
            if (!fromElement.isFetch() || fromElement.isCollectionJoin() || fromElement.getQueryableCollection() != null || !fromElement.getDataType().isEntityType()) continue;
            EntityType entityType = (EntityType)fromElement.getDataType();
            if (entityType.isOneToOne()) {
                this.owners[n] = list.indexOf(fromElement.getOrigin());
            }
            this.ownerAssociationTypes[n] = entityType;
        }
        this.defaultLockModes = ArrayHelper.fillArray(LockMode.NONE, n2);
    }

    public final void validateScrollability() throws HibernateException {
        this.queryTranslator.validateScrollability();
    }

    protected boolean needsFetchingScroll() {
        return this.queryTranslator.containsCollectionFetches();
    }

    public Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    public String[] getAliases() {
        return this.sqlAliases;
    }

    public String[] getSqlAliasSuffixes() {
        return this.sqlAliasSuffixes;
    }

    public String[] getSuffixes() {
        return this.getSqlAliasSuffixes();
    }

    public String[] getCollectionSuffixes() {
        return this.collectionSuffixes;
    }

    protected String getQueryIdentifier() {
        return this.queryTranslator.getQueryIdentifier();
    }

    protected String getSQLString() {
        return this.queryTranslator.getSQLString();
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    protected int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    protected boolean[] getEntityEagerPropertyFetches() {
        return this.entityEagerPropertyFetches;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected EntityType[] getOwnerAssociationTypes() {
        return this.ownerAssociationTypes;
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    protected LockMode[] getLockModes(Map map) {
        if (map == null || map.size() == 0) {
            return this.defaultLockModes;
        }
        LockMode[] lockModeArray = new LockMode[this.entityAliases.length];
        for (int i = 0; i < this.entityAliases.length; ++i) {
            LockMode lockMode = (LockMode)map.get(this.entityAliases[i]);
            if (lockMode == null) {
                lockMode = LockMode.NONE;
            }
            lockModeArray[i] = lockMode;
        }
        return lockModeArray;
    }

    protected String applyLocks(String string, Map map, Dialect dialect) throws QueryException {
        if (map == null || map.size() == 0) {
            return string;
        }
        HashMap hashMap = new HashMap();
        HashMap<String, String[]> hashMap2 = dialect.forUpdateOfColumns() ? new HashMap<String, String[]>() : null;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)this.sqlAliasByEntityAlias.get(string2);
            if (string3 == null) {
                throw new IllegalArgumentException("could not locate alias to apply lock mode : " + string2);
            }
            QueryNode queryNode = (QueryNode)this.queryTranslator.getSqlAST();
            Lockable lockable = (Lockable)((Object)queryNode.getFromClause().getFromElement(string2).getQueryable());
            String string4 = lockable.getRootTableAlias(string3);
            hashMap.put(string4, entry.getValue());
            if (hashMap2 == null) continue;
            hashMap2.put(string4, lockable.getRootTableIdentifierColumnNames());
        }
        return dialect.applyLocksToSql(string, hashMap, hashMap2);
    }

    protected boolean upgradeLocks() {
        return true;
    }

    private boolean hasSelectNew() {
        return this.selectNewTransformer != null;
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        boolean bl;
        objectArray = this.toResultRow(objectArray);
        boolean bl2 = bl = this.hasSelectNew() || resultTransformer != null;
        if (this.hasScalars) {
            String[][] stringArray = this.scalarColumnNames;
            int n = this.queryReturnTypes.length;
            if (!bl && n == 1) {
                return this.queryReturnTypes[0].nullSafeGet(resultSet, stringArray[0], sessionImplementor, null);
            }
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.queryReturnTypes[i].nullSafeGet(resultSet, stringArray[i], sessionImplementor, null);
            }
            return objectArray;
        }
        if (!bl) {
            return objectArray.length == 1 ? objectArray[0] : objectArray;
        }
        return objectArray;
    }

    protected List getResultList(List list, ResultTransformer resultTransformer) throws QueryException {
        HolderInstantiator holderInstantiator = HolderInstantiator.getHolderInstantiator(this.selectNewTransformer, resultTransformer, this.queryReturnAliases);
        if (holderInstantiator.isRequired()) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                Object object = holderInstantiator.instantiate(objectArray);
                list.set(i, object);
            }
            if (!this.hasSelectNew() && resultTransformer != null) {
                return resultTransformer.transformList(list);
            }
            return list;
        }
        return list;
    }

    public List list(SessionImplementor sessionImplementor, QueryParameters queryParameters) throws HibernateException {
        this.checkQuery(queryParameters);
        return this.list(sessionImplementor, queryParameters, this.queryTranslator.getQuerySpaces(), this.queryReturnTypes);
    }

    private void checkQuery(QueryParameters queryParameters) {
        if (this.hasSelectNew() && queryParameters.getResultTransformer() != null) {
            throw new QueryException("ResultTransformer is not allowed for 'select new' queries.");
        }
    }

    public Iterator iterate(QueryParameters queryParameters, EventSource eventSource) throws HibernateException {
        this.checkQuery(queryParameters);
        boolean bl = eventSource.getFactory().getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        try {
            PreparedStatement preparedStatement = this.prepareQueryStatement(queryParameters, false, eventSource);
            if (queryParameters.isCallable()) {
                throw new QueryException("iterate() not supported for callable statements");
            }
            ResultSet resultSet = this.getResultSet(preparedStatement, queryParameters.hasAutoDiscoverScalarTypes(), false, queryParameters.getRowSelection(), eventSource);
            IteratorImpl iteratorImpl = new IteratorImpl(resultSet, preparedStatement, eventSource, this.queryReturnTypes, this.queryTranslator.getColumnNames(), HolderInstantiator.getHolderInstantiator(this.selectNewTransformer, queryParameters.getResultTransformer(), this.queryReturnAliases));
            if (bl) {
                eventSource.getFactory().getStatisticsImplementor().queryExecuted(this.getQueryIdentifier(), 0, System.currentTimeMillis() - l);
            }
            return iteratorImpl;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not execute query using iterate", this.getSQLString());
        }
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.checkQuery(queryParameters);
        return this.scroll(queryParameters, this.queryReturnTypes, HolderInstantiator.getHolderInstantiator(this.selectNewTransformer, queryParameters.getResultTransformer(), this.queryReturnAliases), sessionImplementor);
    }

    private Object[] toResultRow(Object[] objectArray) {
        if (this.selectLength == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[this.selectLength];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.includeInSelect[i]) continue;
            objectArray2[n++] = objectArray[i];
        }
        return objectArray2;
    }

    public int[] getNamedParameterLocs(String string) throws QueryException {
        return this.queryTranslator.getParameterTranslations().getNamedParameterSqlLocations(string);
    }

    protected int bindParameterValues(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException {
        int n2 = this.bindFilterParameterValues(preparedStatement, queryParameters, n, sessionImplementor);
        ArrayList arrayList = this.queryTranslator.getSqlAST().getWalker().getParameters();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ParameterSpecification parameterSpecification = (ParameterSpecification)iterator.next();
            n2 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n2);
        }
        return n2 - n;
    }

    private int bindFilterParameterValues(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException {
        int n2 = queryParameters.getFilteredPositionalParameterTypes() == null ? 0 : queryParameters.getFilteredPositionalParameterTypes().length;
        int n3 = queryParameters.getPositionalParameterTypes() == null ? 0 : queryParameters.getPositionalParameterTypes().length;
        int n4 = n2 - n3;
        for (int i = 0; i < n4; ++i) {
            Type type = queryParameters.getFilteredPositionalParameterTypes()[i];
            Object object = queryParameters.getFilteredPositionalParameterValues()[i];
            type.nullSafeSet(preparedStatement, object, n, sessionImplementor);
            n += type.getColumnSpan(this.getFactory());
        }
        return n;
    }
}

