/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.entity.AbstractEntityLoader;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.Type;

public class EntityLoader
extends AbstractEntityLoader {
    private final boolean batchLoader;

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        this(outerJoinLoadable, 1, lockMode, sessionFactoryImplementor, map);
    }

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        this(outerJoinLoadable, outerJoinLoadable.getIdentifierColumnNames(), outerJoinLoadable.getIdentifierType(), n, lockMode, sessionFactoryImplementor, map);
    }

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, String[] stringArray, Type type, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        super(outerJoinLoadable, type, sessionFactoryImplementor, map);
        EntityJoinWalker entityJoinWalker = new EntityJoinWalker(outerJoinLoadable, stringArray, n, lockMode, sessionFactoryImplementor, map);
        this.initFromWalker(entityJoinWalker);
        this.postInstantiate();
        this.batchLoader = n > 1;
        log.debug((Object)("Static select for entity " + this.entityName + ": " + this.getSQLString()));
    }

    public Object loadByUniqueKey(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.load(sessionImplementor, object, null, null);
    }

    protected boolean isSingleRowLoader() {
        return !this.batchLoader;
    }
}

