/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CollectionElementLoader
extends OuterJoinLoader {
    private static final Log log = LogFactory.getLog((Class)CollectionElementLoader.class);
    private final OuterJoinLoadable persister;
    private final Type keyType;
    private final Type indexType;
    private final String entityName;

    public CollectionElementLoader(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        super(sessionFactoryImplementor, map);
        this.keyType = queryableCollection.getKeyType();
        this.indexType = queryableCollection.getIndexType();
        this.persister = (OuterJoinLoadable)queryableCollection.getElementPersister();
        this.entityName = this.persister.getEntityName();
        EntityJoinWalker entityJoinWalker = new EntityJoinWalker(this.persister, ArrayHelper.join(queryableCollection.getKeyColumnNames(), queryableCollection.getIndexColumnNames()), 1, LockMode.NONE, sessionFactoryImplementor, map);
        this.initFromWalker(entityJoinWalker);
        this.postInstantiate();
        log.debug((Object)("Static select for entity " + this.entityName + ": " + this.getSQLString()));
    }

    public Object loadElement(SessionImplementor sessionImplementor, Object object, Object object2) throws HibernateException {
        List list = this.loadEntity(sessionImplementor, object, object2, this.keyType, this.indexType, this.persister);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        if (this.getCollectionOwners() != null) {
            return list.get(0);
        }
        throw new HibernateException("More than one row was found");
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return objectArray[objectArray.length - 1];
    }

    protected boolean isSingleRowLoader() {
        return true;
    }
}

