/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public abstract class AbstractEntityLoader
extends OuterJoinLoader
implements UniqueEntityLoader {
    protected static final Log log = LogFactory.getLog((Class)EntityLoader.class);
    protected final OuterJoinLoadable persister;
    protected final Type uniqueKeyType;
    protected final String entityName;

    public AbstractEntityLoader(OuterJoinLoadable outerJoinLoadable, Type type, SessionFactoryImplementor sessionFactoryImplementor, Map map) {
        super(sessionFactoryImplementor, map);
        this.uniqueKeyType = type;
        this.entityName = outerJoinLoadable.getEntityName();
        this.persister = outerJoinLoadable;
    }

    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        return this.load(sessionImplementor, serializable, object, serializable);
    }

    protected Object load(SessionImplementor sessionImplementor, Object object, Object object2, Serializable serializable) throws HibernateException {
        List list = this.loadEntity(sessionImplementor, object, this.uniqueKeyType, object2, this.entityName, serializable, this.persister);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        if (this.getCollectionOwners() != null) {
            return list.get(0);
        }
        throw new HibernateException("More than one row with the given identifier was found: " + object + ", for class: " + this.persister.getEntityName());
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return objectArray[objectArray.length - 1];
    }

    protected boolean isSingleRowLoader() {
        return true;
    }
}

