/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.Loader;
import org.hibernate.loader.custom.CollectionFetchReturn;
import org.hibernate.loader.custom.CollectionReturn;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.EntityFetchReturn;
import org.hibernate.loader.custom.FetchReturn;
import org.hibernate.loader.custom.NonScalarReturn;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.ScalarReturn;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class CustomLoader
extends Loader {
    private final String sql;
    private final Set querySpaces = new HashSet();
    private final Map namedParameterBindPoints;
    private final Queryable[] entityPersisters;
    private final int[] entiytOwners;
    private final EntityAliases[] entityAliases;
    private final QueryableCollection[] collectionPersisters;
    private final int[] collectionOwners;
    private final CollectionAliases[] collectionAliases;
    private final LockMode[] lockModes;
    private final ResultRowProcessor rowProcessor;
    private Type[] resultTypes;
    private String[] transformerAliases;

    public CustomLoader(CustomQuery customQuery, SessionFactoryImplementor sessionFactoryImplementor) {
        super(sessionFactoryImplementor);
        int n;
        this.sql = customQuery.getSQL();
        this.querySpaces.addAll(customQuery.getQuerySpaces());
        this.namedParameterBindPoints = customQuery.getNamedParameterBindPoints();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<EntityAliases> arrayList3 = new ArrayList<EntityAliases>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<CollectionAliases> arrayList6 = new ArrayList<CollectionAliases>();
        ArrayList<LockMode> arrayList7 = new ArrayList<LockMode>();
        ArrayList<ResultColumnProcessor> arrayList8 = new ArrayList<ResultColumnProcessor>();
        ArrayList<Return> arrayList9 = new ArrayList<Return>();
        ArrayList<Type> arrayList10 = new ArrayList<Type>();
        ArrayList<String> arrayList11 = new ArrayList<String>();
        int n2 = 0;
        boolean bl = false;
        Iterator iterator = customQuery.getCustomQueryReturns().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Return return_;
            Return return_2 = (Return)iterator.next();
            if (return_2 instanceof ScalarReturn) {
                return_ = (ScalarReturn)return_2;
                arrayList10.add(((ScalarReturn)return_).getType());
                arrayList11.add(((ScalarReturn)return_).getColumnAlias());
                arrayList8.add(new ScalarResultColumnProcessor(((ScalarReturn)return_).getColumnAlias(), ((ScalarReturn)return_).getType()));
                bl = true;
                continue;
            }
            if (return_2 instanceof RootReturn) {
                return_ = (RootReturn)return_2;
                object5 = (Queryable)sessionFactoryImplementor.getEntityPersister(((RootReturn)return_).getEntityName());
                arrayList.add(object5);
                arrayList7.add(((NonScalarReturn)return_).getLockMode());
                arrayList8.add(new NonScalarResultColumnProcessor(n2++));
                arrayList9.add(return_2);
                arrayList2.add(new Integer(-1));
                arrayList10.add(object5.getType());
                arrayList11.add(((NonScalarReturn)return_).getAlias());
                arrayList3.add(((RootReturn)return_).getEntityAliases());
                ArrayHelper.addAll(this.querySpaces, object5.getQuerySpaces());
                continue;
            }
            if (return_2 instanceof CollectionReturn) {
                return_ = (CollectionReturn)return_2;
                object5 = ((CollectionReturn)return_).getOwnerEntityName() + "." + ((CollectionReturn)return_).getOwnerProperty();
                QueryableCollection queryableCollection = (QueryableCollection)sessionFactoryImplementor.getCollectionPersister((String)object5);
                arrayList4.add(queryableCollection);
                arrayList7.add(((NonScalarReturn)return_).getLockMode());
                arrayList8.add(new NonScalarResultColumnProcessor(n2++));
                arrayList9.add(return_2);
                arrayList5.add(new Integer(-1));
                arrayList10.add(queryableCollection.getType());
                arrayList11.add(((NonScalarReturn)return_).getAlias());
                arrayList6.add(((CollectionReturn)return_).getCollectionAliases());
                object4 = queryableCollection.getElementType();
                if (!object4.isEntityType()) continue;
                object3 = (Queryable)((EntityType)object4).getAssociatedJoinable(sessionFactoryImplementor);
                arrayList.add(object3);
                arrayList2.add(new Integer(-1));
                arrayList3.add(((CollectionReturn)return_).getElementEntityAliases());
                ArrayHelper.addAll(this.querySpaces, object3.getQuerySpaces());
                continue;
            }
            if (return_2 instanceof EntityFetchReturn) {
                return_ = (EntityFetchReturn)return_2;
                object5 = ((FetchReturn)return_).getOwner();
                int n3 = arrayList9.indexOf(object5);
                arrayList2.add(new Integer(n3));
                arrayList7.add(((NonScalarReturn)return_).getLockMode());
                object4 = this.determineAppropriateOwnerPersister((NonScalarReturn)object5);
                object3 = (EntityType)object4.getPropertyType(((FetchReturn)return_).getOwnerProperty());
                object2 = ((EntityType)object3).getAssociatedEntityName(this.getFactory());
                object = (Queryable)sessionFactoryImplementor.getEntityPersister((String)object2);
                arrayList.add(object);
                arrayList9.add(return_2);
                arrayList11.add(((NonScalarReturn)return_).getAlias());
                arrayList3.add(((EntityFetchReturn)return_).getEntityAliases());
                ArrayHelper.addAll(this.querySpaces, object.getQuerySpaces());
                continue;
            }
            if (return_2 instanceof CollectionFetchReturn) {
                return_ = (CollectionFetchReturn)return_2;
                object5 = ((FetchReturn)return_).getOwner();
                int n4 = arrayList9.indexOf(object5);
                arrayList5.add(new Integer(n4));
                arrayList7.add(((NonScalarReturn)return_).getLockMode());
                object4 = this.determineAppropriateOwnerPersister((NonScalarReturn)object5);
                object3 = object4.getEntityName() + '.' + ((FetchReturn)return_).getOwnerProperty();
                object2 = (QueryableCollection)sessionFactoryImplementor.getCollectionPersister((String)object3);
                arrayList4.add(object2);
                arrayList9.add(return_2);
                arrayList11.add(((NonScalarReturn)return_).getAlias());
                arrayList6.add(((CollectionFetchReturn)return_).getCollectionAliases());
                object = object2.getElementType();
                if (!object.isEntityType()) continue;
                Queryable queryable = (Queryable)((EntityType)object).getAssociatedJoinable(sessionFactoryImplementor);
                arrayList.add(queryable);
                arrayList2.add(new Integer(n4));
                arrayList3.add(((CollectionFetchReturn)return_).getElementEntityAliases());
                ArrayHelper.addAll(this.querySpaces, queryable.getQuerySpaces());
                continue;
            }
            throw new HibernateException("unexpected custom query return type : " + return_2.getClass().getName());
        }
        this.entityPersisters = new Queryable[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.entityPersisters[n] = (Queryable)arrayList.get(n);
        }
        this.entiytOwners = ArrayHelper.toIntArray(arrayList2);
        this.entityAliases = new EntityAliases[arrayList3.size()];
        for (n = 0; n < arrayList3.size(); ++n) {
            this.entityAliases[n] = (EntityAliases)arrayList3.get(n);
        }
        this.collectionPersisters = new QueryableCollection[arrayList4.size()];
        for (n = 0; n < arrayList4.size(); ++n) {
            this.collectionPersisters[n] = (QueryableCollection)arrayList4.get(n);
        }
        this.collectionOwners = ArrayHelper.toIntArray(arrayList5);
        this.collectionAliases = new CollectionAliases[arrayList6.size()];
        for (n = 0; n < arrayList6.size(); ++n) {
            this.collectionAliases[n] = (CollectionAliases)arrayList6.get(n);
        }
        this.lockModes = new LockMode[arrayList7.size()];
        for (n = 0; n < arrayList7.size(); ++n) {
            this.lockModes[n] = (LockMode)arrayList7.get(n);
        }
        this.resultTypes = ArrayHelper.toTypeArray(arrayList10);
        this.transformerAliases = ArrayHelper.toStringArray(arrayList11);
        this.rowProcessor = new ResultRowProcessor(bl, arrayList8.toArray(new ResultColumnProcessor[arrayList8.size()]));
    }

    private Queryable determineAppropriateOwnerPersister(NonScalarReturn nonScalarReturn) {
        String string = null;
        if (nonScalarReturn instanceof RootReturn) {
            string = ((RootReturn)nonScalarReturn).getEntityName();
        } else if (nonScalarReturn instanceof CollectionReturn) {
            CollectionReturn collectionReturn = (CollectionReturn)nonScalarReturn;
            String string2 = collectionReturn.getOwnerEntityName() + "." + collectionReturn.getOwnerProperty();
            CollectionPersister collectionPersister = this.getFactory().getCollectionPersister(string2);
            EntityType entityType = (EntityType)collectionPersister.getElementType();
            string = entityType.getAssociatedEntityName(this.getFactory());
        } else if (nonScalarReturn instanceof FetchReturn) {
            Type type;
            FetchReturn fetchReturn = (FetchReturn)nonScalarReturn;
            Queryable queryable = this.determineAppropriateOwnerPersister(fetchReturn.getOwner());
            Type type2 = queryable.getPropertyType(fetchReturn.getOwnerProperty());
            if (type2.isEntityType()) {
                string = ((EntityType)type2).getAssociatedEntityName(this.getFactory());
            } else if (type2.isCollectionType() && (type = ((CollectionType)type2).getElementType(this.getFactory())).isEntityType()) {
                string = ((EntityType)type).getAssociatedEntityName(this.getFactory());
            }
        }
        if (string == null) {
            throw new HibernateException("Could not determine fetch owner : " + nonScalarReturn);
        }
        return (Queryable)this.getFactory().getEntityPersister(string);
    }

    protected String getQueryIdentifier() {
        return this.sql;
    }

    protected String getSQLString() {
        return this.sql;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected LockMode[] getLockModes(Map map) {
        return this.lockModes;
    }

    protected Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    protected CollectionPersister[] getCollectionPersisters() {
        return this.collectionPersisters;
    }

    protected int[] getCollectionOwners() {
        return this.collectionOwners;
    }

    protected int[] getOwners() {
        return this.entiytOwners;
    }

    public List list(SessionImplementor sessionImplementor, QueryParameters queryParameters) throws HibernateException {
        return this.list(sessionImplementor, queryParameters, this.querySpaces, this.resultTypes);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        return this.scroll(queryParameters, this.resultTypes, CustomLoader.getHolderInstantiator(queryParameters.getResultTransformer(), this.getReturnAliasesForTransformer()), sessionImplementor);
    }

    private static HolderInstantiator getHolderInstantiator(ResultTransformer resultTransformer, String[] stringArray) {
        if (resultTransformer != null) {
            return HolderInstantiator.NOOP_INSTANTIATOR;
        }
        return new HolderInstantiator(resultTransformer, stringArray);
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return this.rowProcessor.buildResultRow(objectArray, resultSet, resultTransformer != null, sessionImplementor);
    }

    protected List getResultList(List list, ResultTransformer resultTransformer) throws QueryException {
        HolderInstantiator holderInstantiator = HolderInstantiator.getHolderInstantiator(null, resultTransformer, this.getReturnAliasesForTransformer());
        if (holderInstantiator.isRequired()) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                Object object = holderInstantiator.instantiate(objectArray);
                list.set(i, object);
            }
            return resultTransformer.transformList(list);
        }
        return list;
    }

    private String[] getReturnAliasesForTransformer() {
        return this.transformerAliases;
    }

    protected EntityAliases[] getEntityAliases() {
        return this.entityAliases;
    }

    protected CollectionAliases[] getCollectionAliases() {
        return this.collectionAliases;
    }

    public int[] getNamedParameterLocs(String string) throws QueryException {
        Object v = this.namedParameterBindPoints.get(string);
        if (v == null) {
            throw new QueryException("Named parameter does not appear in Query: " + string, this.sql);
        }
        if (v instanceof Integer) {
            return new int[]{(Integer)v};
        }
        return ArrayHelper.toIntArray((List)v);
    }

    protected void autoDiscoverTypes(ResultSet resultSet) {
        try {
            Metadata metadata = new Metadata(this.getFactory(), resultSet);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.rowProcessor.prepareForAutoDiscovery(metadata);
            for (int i = 0; i < this.rowProcessor.columnProcessors.length; ++i) {
                this.rowProcessor.columnProcessors[i].performDiscovery(metadata, arrayList2, arrayList);
            }
            this.resultTypes = ArrayHelper.toTypeArray(arrayList2);
            this.transformerAliases = ArrayHelper.toStringArray(arrayList);
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Exception while trying to autodiscover types.", sQLException);
        }
    }

    private static class Metadata {
        private final SessionFactoryImplementor factory;
        private final ResultSet resultSet;
        private final ResultSetMetaData resultSetMetaData;

        public Metadata(SessionFactoryImplementor sessionFactoryImplementor, ResultSet resultSet) throws HibernateException {
            try {
                this.factory = sessionFactoryImplementor;
                this.resultSet = resultSet;
                this.resultSetMetaData = resultSet.getMetaData();
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Could not extract result set metadata", sQLException);
            }
        }

        public int getColumnCount() throws HibernateException {
            try {
                return this.resultSetMetaData.getColumnCount();
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Could not determine result set column count", sQLException);
            }
        }

        public int resolveColumnPosition(String string) throws HibernateException {
            try {
                return this.resultSet.findColumn(string);
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Could not resolve column name in result set [" + string + "]", sQLException);
            }
        }

        public String getColumnName(int n) throws HibernateException {
            try {
                return this.resultSetMetaData.getColumnName(n);
            }
            catch (SQLException sQLException) {
                throw new HibernateException("Could not resolve column name [" + n + "]", sQLException);
            }
        }

        public Type getHibernateType(int n) throws SQLException {
            int n2 = this.resultSetMetaData.getColumnType(n);
            int n3 = this.resultSetMetaData.getScale(n);
            int n4 = this.resultSetMetaData.getPrecision(n);
            return TypeFactory.heuristicType(this.factory.getDialect().getHibernateTypeName(n2, n4, n4, n3));
        }
    }

    public class NonScalarResultColumnProcessor
    implements ResultColumnProcessor {
        private final int position;

        public NonScalarResultColumnProcessor(int n) {
            this.position = n;
        }

        public Object extract(Object[] objectArray, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
            return objectArray[this.position];
        }

        public void performDiscovery(Metadata metadata, List list, List list2) {
        }
    }

    private static interface ResultColumnProcessor {
        public Object extract(Object[] var1, ResultSet var2, SessionImplementor var3) throws SQLException, HibernateException;

        public void performDiscovery(Metadata var1, List var2, List var3) throws SQLException, HibernateException;
    }

    public class ResultRowProcessor {
        private final boolean hasScalars;
        private ResultColumnProcessor[] columnProcessors;

        public ResultRowProcessor(boolean bl, ResultColumnProcessor[] resultColumnProcessorArray) {
            this.hasScalars = bl || resultColumnProcessorArray == null || resultColumnProcessorArray.length == 0;
            this.columnProcessors = resultColumnProcessorArray;
        }

        public void prepareForAutoDiscovery(Metadata metadata) throws SQLException {
            if (this.columnProcessors == null || this.columnProcessors.length == 0) {
                int n = metadata.getColumnCount();
                this.columnProcessors = new ResultColumnProcessor[n];
                for (int i = 1; i <= n; ++i) {
                    this.columnProcessors[i - 1] = new ScalarResultColumnProcessor(i);
                }
            }
        }

        public Object buildResultRow(Object[] objectArray, ResultSet resultSet, boolean bl, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
            Object[] objectArray2;
            if (!this.hasScalars) {
                objectArray2 = objectArray;
            } else {
                objectArray2 = new Object[this.columnProcessors.length];
                for (int i = 0; i < this.columnProcessors.length; ++i) {
                    objectArray2[i] = this.columnProcessors[i].extract(objectArray, resultSet, sessionImplementor);
                }
            }
            return bl ? objectArray2 : (objectArray2.length == 1 ? objectArray2[0] : objectArray2);
        }
    }

    public class ScalarResultColumnProcessor
    implements ResultColumnProcessor {
        private int position = -1;
        private String alias;
        private Type type;

        public ScalarResultColumnProcessor(int n) {
            this.position = n;
        }

        public ScalarResultColumnProcessor(String string, Type type) {
            this.alias = string;
            this.type = type;
        }

        public Object extract(Object[] objectArray, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
            return this.type.nullSafeGet(resultSet, this.alias, sessionImplementor, null);
        }

        public void performDiscovery(Metadata metadata, List list, List list2) throws SQLException {
            if (this.alias == null) {
                this.alias = metadata.getColumnName(this.position);
            } else if (this.position < 0) {
                this.position = metadata.resolveColumnPosition(this.alias);
            }
            if (this.type == null) {
                this.type = metadata.getHibernateType(this.position);
            }
            list.add(this.type);
            list2.add(this.alias);
        }
    }
}

