/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class CriteriaLoader
extends OuterJoinLoader {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final String[] userAliases;

    public CriteriaLoader(OuterJoinLoadable outerJoinLoadable, SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, Map map) throws HibernateException {
        super(sessionFactoryImplementor, map);
        this.translator = new CriteriaQueryTranslator(sessionFactoryImplementor, criteriaImpl, string, "this_");
        this.querySpaces = this.translator.getQuerySpaces();
        CriteriaJoinWalker criteriaJoinWalker = new CriteriaJoinWalker(outerJoinLoadable, this.translator, sessionFactoryImplementor, criteriaImpl, string, map);
        this.initFromWalker(criteriaJoinWalker);
        this.userAliases = criteriaJoinWalker.getUserAliases();
        this.resultTypes = criteriaJoinWalker.getResultTypes();
        this.postInstantiate();
    }

    public ScrollableResults scroll(SessionImplementor sessionImplementor, ScrollMode scrollMode) throws HibernateException {
        QueryParameters queryParameters = this.translator.getQueryParameters();
        queryParameters.setScrollMode(scrollMode);
        return this.scroll(queryParameters, this.resultTypes, null, sessionImplementor);
    }

    public List list(SessionImplementor sessionImplementor) throws HibernateException {
        return this.list(sessionImplementor, this.translator.getQueryParameters(), this.querySpaces, this.resultTypes);
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        String[] stringArray;
        Object[] objectArray2;
        if (this.translator.hasProjection()) {
            Type[] typeArray = this.translator.getProjectedTypes();
            objectArray2 = new Object[typeArray.length];
            String[] stringArray2 = this.translator.getProjectedColumnAliases();
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = typeArray[i].nullSafeGet(resultSet, stringArray2[i], sessionImplementor, null);
            }
            stringArray = this.translator.getProjectedAliases();
        } else {
            objectArray2 = objectArray;
            stringArray = this.userAliases;
        }
        return this.translator.getRootCriteria().getResultTransformer().transformTuple(objectArray2, stringArray);
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected String applyLocks(String string, Map map, Dialect dialect) throws QueryException {
        if (map == null || map.isEmpty()) {
            return string;
        }
        HashMap<String, LockMode> hashMap = new HashMap<String, LockMode>();
        HashMap<String, String[]> hashMap2 = dialect.forUpdateOfColumns() ? new HashMap<String, String[]>() : null;
        String[] stringArray = this.getAliases();
        for (int i = 0; i < stringArray.length; ++i) {
            LockMode lockMode = (LockMode)map.get(stringArray[i]);
            if (lockMode == null) continue;
            Lockable lockable = (Lockable)((Object)this.getEntityPersisters()[i]);
            String string2 = lockable.getRootTableAlias(stringArray[i]);
            hashMap.put(string2, lockMode);
            if (hashMap2 == null) continue;
            hashMap2.put(string2, lockable.getRootTableIdentifierColumnNames());
        }
        return dialect.applyLocksToSql(string, hashMap, hashMap2);
    }

    protected LockMode[] getLockModes(Map map) {
        String[] stringArray = this.getAliases();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        LockMode[] lockModeArray = new LockMode[n];
        for (int i = 0; i < n; ++i) {
            LockMode lockMode = (LockMode)map.get(stringArray[i]);
            lockModeArray[i] = lockMode == null ? LockMode.NONE : lockMode;
        }
        return lockModeArray;
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    protected List getResultList(List list, ResultTransformer resultTransformer) {
        return this.translator.getRootCriteria().getResultTransformer().transformList(list);
    }
}

