/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public class CriteriaJoinWalker
extends AbstractEntityJoinWalker {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final String[] userAliases;
    private final List userAliasList = new ArrayList();

    public Type[] getResultTypes() {
        return this.resultTypes;
    }

    public String[] getUserAliases() {
        return this.userAliases;
    }

    public CriteriaJoinWalker(OuterJoinLoadable outerJoinLoadable, CriteriaQueryTranslator criteriaQueryTranslator, SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, Map map) throws HibernateException {
        super(outerJoinLoadable, sessionFactoryImplementor, map);
        this.translator = criteriaQueryTranslator;
        this.querySpaces = criteriaQueryTranslator.getQuerySpaces();
        if (criteriaQueryTranslator.hasProjection()) {
            this.resultTypes = criteriaQueryTranslator.getProjectedTypes();
            this.initProjection(criteriaQueryTranslator.getSelect(), criteriaQueryTranslator.getWhereCondition(), criteriaQueryTranslator.getOrderBy(), criteriaQueryTranslator.getGroupBy(), LockMode.NONE);
        } else {
            this.resultTypes = new Type[]{TypeFactory.manyToOne(outerJoinLoadable.getEntityName())};
            this.initAll(criteriaQueryTranslator.getWhereCondition(), criteriaQueryTranslator.getOrderBy(), LockMode.NONE);
        }
        this.userAliasList.add(criteriaImpl.getAlias());
        this.userAliases = ArrayHelper.toStringArray(this.userAliasList);
    }

    protected int getJoinType(AssociationType associationType, FetchMode fetchMode, String string, String string2, String[] stringArray, boolean bl, int n, CascadeStyle cascadeStyle) throws MappingException {
        if (this.translator.isJoin(string)) {
            return this.translator.getJoinType(string);
        }
        if (this.translator.hasProjection()) {
            return -1;
        }
        FetchMode fetchMode2 = this.translator.getRootCriteria().getFetchMode(string);
        if (CriteriaJoinWalker.isDefaultFetchMode(fetchMode2)) {
            return super.getJoinType(associationType, fetchMode, string, string2, stringArray, bl, n, cascadeStyle);
        }
        if (fetchMode2 == FetchMode.JOIN) {
            this.isDuplicateAssociation(string2, stringArray, associationType);
            return this.getJoinType(bl, n);
        }
        return -1;
    }

    private static boolean isDefaultFetchMode(FetchMode fetchMode) {
        return fetchMode == null || fetchMode == FetchMode.DEFAULT;
    }

    protected String getWhereFragment() throws MappingException {
        return super.getWhereFragment() + ((Queryable)this.getPersister()).filterFragment(this.getAlias(), this.getEnabledFilters());
    }

    protected String generateTableAlias(int n, String string, Joinable joinable) {
        if (joinable.consumesEntityAlias()) {
            String string2;
            Criteria criteria = this.translator.getCriteria(string);
            String string3 = string2 = criteria == null ? null : this.translator.getSQLAlias(criteria);
            if (string2 != null) {
                this.userAliasList.add(criteria.getAlias());
                return string2;
            }
            this.userAliasList.add(null);
        }
        return super.generateTableAlias(n + this.translator.getSQLAliasCount(), string, joinable);
    }

    protected String generateRootAlias(String string) {
        return "this_";
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public String getComment() {
        return "criteria query";
    }
}

