/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.Type;

public class SubselectCollectionLoader
extends BasicCollectionLoader {
    private final Serializable[] keys;
    private final Type[] types;
    private final Object[] values;
    private final Map namedParameters;
    private final Map namedParameterLocMap;

    public SubselectCollectionLoader(QueryableCollection queryableCollection, String string, Collection collection, QueryParameters queryParameters, Map map, SessionFactoryImplementor sessionFactoryImplementor, Map map2) throws MappingException {
        super(queryableCollection, 1, string, sessionFactoryImplementor, map2);
        this.keys = new Serializable[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.keys[n++] = ((EntityKey)iterator.next()).getIdentifier();
        }
        this.namedParameters = queryParameters.getNamedParameters();
        this.types = queryParameters.getFilteredPositionalParameterTypes();
        this.values = queryParameters.getFilteredPositionalParameterValues();
        this.namedParameterLocMap = map;
    }

    public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        this.loadCollectionSubselect(sessionImplementor, this.keys, this.values, this.types, this.namedParameters, this.getKeyType());
    }

    public int[] getNamedParameterLocs(String string) {
        return (int[])this.namedParameterLocMap.get(string);
    }
}

