/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.loader.collection.OneToManyJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;

public class OneToManyLoader
extends CollectionLoader {
    private static final Log log = LogFactory.getLog((Class)OneToManyLoader.class);

    public OneToManyLoader(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        this(queryableCollection, 1, sessionFactoryImplementor, map);
    }

    public OneToManyLoader(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        this(queryableCollection, n, null, sessionFactoryImplementor, map);
    }

    public OneToManyLoader(QueryableCollection queryableCollection, int n, String string, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        super(queryableCollection, sessionFactoryImplementor, map);
        OneToManyJoinWalker oneToManyJoinWalker = new OneToManyJoinWalker(queryableCollection, n, string, sessionFactoryImplementor, map);
        this.initFromWalker(oneToManyJoinWalker);
        this.postInstantiate();
        log.debug((Object)("Static select for one-to-many " + queryableCollection.getRole() + ": " + this.getSQLString()));
    }
}

