/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.collection.CollectionJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class OneToManyJoinWalker
extends CollectionJoinWalker {
    private final QueryableCollection oneToManyPersister;

    protected boolean isDuplicateAssociation(String string, String[] stringArray) {
        boolean bl = this.oneToManyPersister.getTableName().equals(string) && Arrays.equals(stringArray, this.oneToManyPersister.getKeyColumnNames());
        return bl || super.isDuplicateAssociation(string, stringArray);
    }

    public OneToManyJoinWalker(QueryableCollection queryableCollection, int n, String string, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        super(sessionFactoryImplementor, map);
        this.oneToManyPersister = queryableCollection;
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)queryableCollection.getElementPersister();
        String string2 = this.generateRootAlias(queryableCollection.getRole());
        this.walkEntityTree(outerJoinLoadable, string2);
        ArrayList<OuterJoinableAssociation> arrayList = new ArrayList<OuterJoinableAssociation>();
        arrayList.addAll(this.associations);
        arrayList.add(new OuterJoinableAssociation(queryableCollection.getCollectionType(), null, null, string2, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(arrayList, LockMode.NONE);
        this.initStatementString(outerJoinLoadable, string2, n, string);
    }

    private void initStatementString(OuterJoinLoadable outerJoinLoadable, String string, int n, String string2) throws MappingException {
        int n2 = OneToManyJoinWalker.countEntityPersisters(this.associations);
        this.suffixes = BasicLoader.generateSuffixes(n2 + 1);
        int n3 = OneToManyJoinWalker.countCollectionPersisters(this.associations) + 1;
        this.collectionSuffixes = BasicLoader.generateSuffixes(n2 + 1, n3);
        StringBuffer stringBuffer = this.whereString(string, this.oneToManyPersister.getKeyColumnNames(), string2, n);
        String string3 = this.oneToManyPersister.filterFragment(string, this.getEnabledFilters());
        stringBuffer.insert(0, StringHelper.moveAndToBeginning(string3));
        JoinFragment joinFragment = this.mergeOuterJoins(this.associations);
        Select select = new Select(this.getDialect()).setSelectClause(this.oneToManyPersister.selectFragment(null, null, string, this.suffixes[n2], this.collectionSuffixes[0], true) + this.selectString(this.associations)).setFromClause(outerJoinLoadable.fromTableFragment(string) + outerJoinLoadable.fromJoinFragment(string, true, true)).setWhereClause(stringBuffer.toString()).setOuterJoins(joinFragment.toFromFragmentString(), joinFragment.toWhereFragmentString() + outerJoinLoadable.whereJoinFragment(string, true, true));
        select.setOrderByClause(this.orderBy(this.associations, this.oneToManyPersister.getSQLOrderByString(string)));
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("load one-to-many " + this.oneToManyPersister.getRole());
        }
        this.sql = select.toStatementString();
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.oneToManyPersister.getRole() + ')';
    }
}

