/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.Loader;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.OneToManyLoader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.util.ArrayHelper;

public class BatchingCollectionInitializer
implements CollectionInitializer {
    private final Loader[] loaders;
    private final int[] batchSizes;
    private final CollectionPersister collectionPersister;

    public BatchingCollectionInitializer(CollectionPersister collectionPersister, int[] nArray, Loader[] loaderArray) {
        this.loaders = loaderArray;
        this.batchSizes = nArray;
        this.collectionPersister = collectionPersister;
    }

    public void initialize(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getCollectionBatch(this.collectionPersister, serializable, this.batchSizes[0], sessionImplementor.getEntityMode());
        for (int i = 0; i < this.batchSizes.length - 1; ++i) {
            int n = this.batchSizes[i];
            if (serializableArray[n - 1] == null) continue;
            Serializable[] serializableArray2 = new Serializable[n];
            System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
            this.loaders[i].loadCollectionBatch(sessionImplementor, serializableArray2, this.collectionPersister.getKeyType());
            return;
        }
        this.loaders[this.batchSizes.length - 1].loadCollection(sessionImplementor, serializable, this.collectionPersister.getKeyType());
    }

    public static CollectionInitializer createBatchingOneToManyInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        if (n > 1) {
            int[] nArray = ArrayHelper.getBatchSizes(n);
            Loader[] loaderArray = new Loader[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                loaderArray[i] = new OneToManyLoader(queryableCollection, nArray[i], sessionFactoryImplementor, map);
            }
            return new BatchingCollectionInitializer(queryableCollection, nArray, loaderArray);
        }
        return new OneToManyLoader(queryableCollection, sessionFactoryImplementor, map);
    }

    public static CollectionInitializer createBatchingCollectionInitializer(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        if (n > 1) {
            int[] nArray = ArrayHelper.getBatchSizes(n);
            Loader[] loaderArray = new Loader[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                loaderArray[i] = new BasicCollectionLoader(queryableCollection, nArray[i], sessionFactoryImplementor, map);
            }
            return new BatchingCollectionInitializer(queryableCollection, nArray, loaderArray);
        }
        return new BasicCollectionLoader(queryableCollection, sessionFactoryImplementor, map);
    }
}

