/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.collection.CollectionJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;

public class BasicCollectionJoinWalker
extends CollectionJoinWalker {
    private final QueryableCollection collectionPersister;

    public BasicCollectionJoinWalker(QueryableCollection queryableCollection, int n, String string, SessionFactoryImplementor sessionFactoryImplementor, Map map) throws MappingException {
        super(sessionFactoryImplementor, map);
        this.collectionPersister = queryableCollection;
        String string2 = this.generateRootAlias(queryableCollection.getRole());
        this.walkCollectionTree(queryableCollection, string2);
        ArrayList<OuterJoinableAssociation> arrayList = new ArrayList<OuterJoinableAssociation>();
        arrayList.addAll(this.associations);
        arrayList.add(new OuterJoinableAssociation(queryableCollection.getCollectionType(), null, null, string2, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(arrayList, LockMode.NONE);
        this.initStatementString(string2, n, string);
    }

    private void initStatementString(String string, int n, String string2) throws MappingException {
        Object object;
        Object object2;
        int n2 = BasicCollectionJoinWalker.countEntityPersisters(this.associations);
        int n3 = BasicCollectionJoinWalker.countCollectionPersisters(this.associations) + 1;
        this.suffixes = BasicLoader.generateSuffixes(n2);
        this.collectionSuffixes = BasicLoader.generateSuffixes(n2, n3);
        StringBuffer stringBuffer = this.whereString(string, this.collectionPersister.getKeyColumnNames(), string2, n);
        String string3 = "";
        String string4 = this.collectionPersister.filterFragment(string, this.getEnabledFilters());
        if (this.collectionPersister.isManyToMany()) {
            object2 = this.associations.iterator();
            object = (AssociationType)this.collectionPersister.getElementType();
            while (object2.hasNext()) {
                OuterJoinableAssociation outerJoinableAssociation = (OuterJoinableAssociation)object2.next();
                if (outerJoinableAssociation.getJoinableType() != object) continue;
                string4 = string4 + this.collectionPersister.getManyToManyFilterFragment(outerJoinableAssociation.getRHSAlias(), this.getEnabledFilters());
                string3 = string3 + this.collectionPersister.getManyToManyOrderByString(outerJoinableAssociation.getRHSAlias());
            }
        }
        stringBuffer.insert(0, StringHelper.moveAndToBeginning(string4));
        object2 = this.mergeOuterJoins(this.associations);
        object = new Select(this.getDialect()).setSelectClause(this.collectionPersister.selectFragment(string, this.collectionSuffixes[0]) + this.selectString(this.associations)).setFromClause(this.collectionPersister.getTableName(), string).setWhereClause(stringBuffer.toString()).setOuterJoins(((JoinFragment)object2).toFromFragmentString(), ((JoinFragment)object2).toWhereFragmentString());
        ((Select)object).setOrderByClause(this.orderBy(this.associations, BasicCollectionJoinWalker.mergeOrderings(this.collectionPersister.getSQLOrderByString(string), string3)));
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            ((Select)object).setComment("load collection " + this.collectionPersister.getRole());
        }
        this.sql = ((Select)object).toStatementString();
    }

    protected int getJoinType(AssociationType associationType, FetchMode fetchMode, String string, Set set, String string2, String[] stringArray, boolean bl, int n) throws MappingException {
        int n2 = super.getJoinType(associationType, fetchMode, string, string2, stringArray, bl, n, null);
        if (n2 == 1 && "".equals(string)) {
            n2 = 0;
        }
        return n2;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.collectionPersister.getRole() + ')';
    }
}

